/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.util.blob.BlobOutputStream;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.util.MessageFormatterDecoratorFactory;
import org.apache.synapse.transport.nhttp.util.NhttpUtil;

public class Axis2HttpRequest {
    private static final Log log = LogFactory.getLog(Axis2HttpRequest.class);
    private EndpointReference epr = null;
    private HttpHost httpHost = null;
    private int timeout = -1;
    private MessageContext msgContext = null;
    MessageFormatter messageFormatter = null;
    OMOutputFormat format = null;
    private ContentOutputBuffer outputBuffer = null;
    private volatile boolean readyToStream = false;
    private volatile boolean sendingCompleted = false;
    private volatile boolean completed = false;
    private String endpointURLPrefix = null;
    private boolean chunked = true;

    public Axis2HttpRequest(EndpointReference epr, HttpHost httpHost, MessageContext msgContext) {
        this.epr = epr;
        this.httpHost = httpHost;
        this.msgContext = msgContext;
        this.format = NhttpUtil.getOMOutputFormat(msgContext);
        this.messageFormatter = MessageFormatterDecoratorFactory.createMessageFormatterDecorator(msgContext);
        this.chunked = !msgContext.isPropertyTrue("DISABLE_CHUNKING");
    }

    public void setReadyToStream(boolean readyToStream) {
        this.readyToStream = readyToStream;
    }

    public void setOutputBuffer(ContentOutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public void clear() {
        this.epr = null;
        this.httpHost = null;
        this.msgContext = null;
        this.format = null;
        this.messageFormatter = null;
        this.outputBuffer = null;
    }

    public EndpointReference getEpr() {
        return this.epr;
    }

    public HttpHost getHttpHost() {
        return this.httpHost;
    }

    public MessageContext getMsgContext() {
        return this.msgContext;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getEndpointURLPrefix() {
        return this.endpointURLPrefix;
    }

    public void setEndpointURLPrefix(String endpointURLPrefix) {
        this.endpointURLPrefix = endpointURLPrefix;
    }

    public HttpRequest getRequest() throws IOException {
        String soapAction;
        URL reqURI;
        BasicHttpEntityEnclosingRequest httpRequest;
        String httpMethod = (String)this.msgContext.getProperty("HTTP_METHOD");
        if (httpMethod == null) {
            httpMethod = "POST";
        }
        this.endpointURLPrefix = (String)this.msgContext.getProperty("ENDPOINT_PREFIX");
        if ("POST".equals(httpMethod) || "PUT".equals(httpMethod)) {
            URL url = new URL(this.epr.getAddress());
            httpRequest = new BasicHttpEntityEnclosingRequest(httpMethod, this.msgContext.isPropertyTrue("POST_TO_URI") ? this.epr.getAddress() : url.getPath() + (url.getQuery() != null ? "?" + url.getQuery() : ""), (ProtocolVersion)(this.msgContext.isPropertyTrue("FORCE_HTTP_1.0") ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1));
            BasicHttpEntity entity = new BasicHttpEntity();
            if (this.msgContext.isPropertyTrue("FORCE_HTTP_1.0")) {
                this.setStreamAsTempData(entity);
            } else {
                entity.setChunked(this.chunked);
                if (!this.chunked) {
                    this.setStreamAsTempData(entity);
                }
            }
            httpRequest.setEntity((HttpEntity)entity);
            httpRequest.setHeader("Content-Type", this.messageFormatter.getContentType(this.msgContext, this.format, this.msgContext.getSoapAction()));
        } else if ("GET".equals(httpMethod) || "DELETE".equals(httpMethod)) {
            reqURI = this.messageFormatter.getTargetAddress(this.msgContext, this.format, new URL(this.epr.getAddress()));
            String path = this.msgContext.isPropertyTrue("POST_TO_URI") ? reqURI.toString() : reqURI.getPath() + (reqURI.getQuery() != null ? "?" + reqURI.getQuery() : "");
            httpRequest = new BasicHttpRequest(httpMethod, path, (ProtocolVersion)(this.msgContext.isPropertyTrue("FORCE_HTTP_1.0") ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1));
            httpRequest.setHeader("Content-Type", this.messageFormatter.getContentType(this.msgContext, this.format, this.msgContext.getSoapAction()));
        } else {
            reqURI = new URL(this.epr.getAddress());
            httpRequest = new BasicHttpRequest(httpMethod, this.msgContext.isPropertyTrue("POST_TO_URI") ? this.epr.getAddress() : reqURI.getPath() + (reqURI.getQuery() != null ? "?" + reqURI.getQuery() : ""), (ProtocolVersion)(this.msgContext.isPropertyTrue("FORCE_HTTP_1.0") ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1));
        }
        Object o = this.msgContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            Map headers = (Map)o;
            for (Object header : headers.keySet()) {
                Object value = headers.get(header);
                if (!(header instanceof String) || value == null || !(value instanceof String) || "Host".equalsIgnoreCase((String)header)) continue;
                httpRequest.setHeader((String)header, (String)value);
            }
        }
        if ((soapAction = this.msgContext.getSoapAction()) == null) {
            soapAction = this.msgContext.getWSAAction();
        }
        if (soapAction == null) {
            this.msgContext.getAxisOperation().getInputAction();
        }
        if (this.msgContext.isSOAP11() && soapAction != null && soapAction.length() > 0) {
            Header existingHeader = httpRequest.getFirstHeader("SOAPAction");
            if (existingHeader != null) {
                httpRequest.removeHeader(existingHeader);
            }
            httpRequest.setHeader("SOAPAction", this.messageFormatter.formatSOAPAction(this.msgContext, null, soapAction));
        }
        if (NHttpConfiguration.getInstance().isKeepAliveDisabled() || this.msgContext.isPropertyTrue("NO_KEEPALIVE")) {
            httpRequest.setHeader("Connection", "Close");
        }
        return httpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamMessageContents() throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start streaming outgoing http request : [Message ID : " + this.msgContext.getMessageID() + "]"));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Message [Request Message ID : " + this.msgContext.getMessageID() + "] " + "[Request Message Payload : [ " + this.msgContext.getEnvelope() + "]"));
            }
        }
        Axis2HttpRequest axis2HttpRequest = this;
        synchronized (axis2HttpRequest) {
            while (!this.readyToStream && !this.completed) {
                try {
                    this.wait();
                }
                catch (InterruptedException ignore) {}
            }
        }
        if (!this.completed) {
            ContentOutputStream out = new ContentOutputStream(this.outputBuffer);
            try {
                if (this.msgContext.isPropertyTrue("FORCE_HTTP_1.0")) {
                    this.writeMessageFromTempData((OutputStream)out);
                } else if (this.chunked) {
                    this.messageFormatter.writeTo(this.msgContext, this.format, (OutputStream)out, false);
                } else {
                    this.writeMessageFromTempData((OutputStream)out);
                }
            }
            catch (Exception e) {
                Throwable t = e.getCause();
                if (t != null && t.getCause() != null && t.getCause() instanceof ClosedChannelException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Ignore closed channel exception, as the SessionRequestCallback handles this exception");
                    }
                } else {
                    Integer errorCode;
                    Integer n = errorCode = this.msgContext == null ? null : (Integer)this.msgContext.getProperty("ERROR_CODE");
                    if (errorCode == null || errorCode == 101509) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Remote server aborted request being sent, and responded");
                        }
                    } else {
                        if (e instanceof AxisFault) {
                            throw (AxisFault)e;
                        }
                        this.handleException("Error streaming message context", e);
                    }
                }
            }
            finally {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    this.handleException("Error closing outgoing message stream", e);
                }
                this.setSendingCompleted(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamAsTempData(BasicHttpEntity entity) throws IOException {
        OverflowBlob serialized = new OverflowBlob(256, 4096, "http-nio_", ".dat");
        BlobOutputStream out = serialized.getOutputStream();
        try {
            this.messageFormatter.writeTo(this.msgContext, this.format, (OutputStream)out, true);
        }
        finally {
            out.close();
        }
        this.msgContext.setProperty("SerializedBytes", (Object)serialized);
        entity.setContentLength(serialized.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessageFromTempData(OutputStream out) throws IOException {
        OverflowBlob serialized = (OverflowBlob)this.msgContext.getProperty("SerializedBytes");
        try {
            serialized.writeTo(out);
        }
        finally {
            serialized.release();
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompleted(boolean completed) {
        this.completed = completed;
        Axis2HttpRequest axis2HttpRequest = this;
        synchronized (axis2HttpRequest) {
            this.notifyAll();
        }
    }

    public boolean isSendingCompleted() {
        return this.sendingCompleted;
    }

    public void setSendingCompleted(boolean sendingCompleted) {
        this.sendingCompleted = sendingCompleted;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Axis2Request [Message ID : ").append(this.msgContext.getMessageID()).append("] ");
        sb.append("[Status Completed : ").append(this.isCompleted() ? "true" : "false").append("] ");
        sb.append("[Status SendingCompleted : ").append(this.isSendingCompleted() ? "true" : "false").append("]");
        return sb.toString();
    }
}

