/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.nhttp.AccessHandler;
import org.apache.synapse.transport.nhttp.LoggingIOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingNHttpClientConnection
extends DefaultNHttpClientConnection {
    private static final AtomicLong COUNT = new AtomicLong();
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Log iolog;
    private final Log headerlog;
    private final Log wirelog;
    private final Log accesslog;
    private final String id;

    public LoggingNHttpClientConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session, responseFactory, allocator, params);
        this.iolog = LogFactory.getLog(session.getClass());
        this.headerlog = LogFactory.getLog((String)"org.apache.synapse.transport.nhttp.headers");
        this.wirelog = LogFactory.getLog((String)"org.apache.synapse.transport.nhttp.wire");
        this.accesslog = LogFactory.getLog((String)"org.apache.synapse.transport.nhttp.access");
        this.id = "http-outgoing-" + COUNT.incrementAndGet();
        if (this.iolog.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.session = new LoggingIOSession(session, this.id, this.iolog, this.wirelog);
        }
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Close connection"));
        }
        super.close();
    }

    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Shutdown connection"));
        }
        super.shutdown();
    }

    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": " + request.getRequestLine().toString()));
        }
        super.submitRequest(request);
    }

    public void consumeInput(NHttpClientHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Consume input"));
        }
        super.consumeInput(handler);
    }

    public void produceOutput(NHttpClientHandler handler) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.id + ": Produce output"));
        }
        super.produceOutput(handler);
    }

    protected NHttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter((NHttpMessageWriter<HttpRequest>)super.createRequestWriter(buffer, params));
    }

    protected NHttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new LoggingNHttpMessageParser((NHttpMessageParser<HttpResponse>)super.createResponseParser(buffer, responseFactory, params));
    }

    public String toString() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingNHttpMessageParser
    implements NHttpMessageParser<HttpResponse> {
        private final NHttpMessageParser<HttpResponse> parser;

        public LoggingNHttpMessageParser(NHttpMessageParser<HttpResponse> parser) {
            this.parser = parser;
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpResponse parse() throws IOException, HttpException {
            HttpResponse message = (HttpResponse)this.parser.parse();
            if (message != null && LoggingNHttpClientConnection.this.headerlog.isDebugEnabled()) {
                LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " << " + message.getStatusLine().toString()));
                Header[] headers = message.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " << " + headers[i].toString()));
                }
            }
            if (message != null && LoggingNHttpClientConnection.this.accesslog.isInfoEnabled()) {
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            return message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter<HttpRequest> {
        private final NHttpMessageWriter<HttpRequest> writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter<HttpRequest> writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        public void write(HttpRequest message) throws IOException, HttpException {
            if (message != null && LoggingNHttpClientConnection.this.headerlog.isDebugEnabled()) {
                LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " >> " + message.getRequestLine().toString()));
                Header[] headers = message.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    LoggingNHttpClientConnection.this.headerlog.debug((Object)(LoggingNHttpClientConnection.this.id + " >> " + headers[i].toString()));
                }
            }
            if (message != null && LoggingNHttpClientConnection.this.accesslog.isInfoEnabled()) {
                AccessHandler.getAccess().addAccessToQueue(message);
            }
            this.writer.write((HttpMessage)message);
        }
    }
}

