/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import jakarta.inject.Named;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.InjectionProvider2;

public class InjectNamedProvider
implements InjectionProvider2 {
    private final ObjectLocator locator;
    private final ComponentClassCache cache;

    public InjectNamedProvider(ObjectLocator locator, ComponentClassCache cache) {
        this.locator = locator;
        this.cache = cache;
    }

    @Override
    public boolean provideInjection(PlasticField field, ObjectLocator locator, MutableComponentModel componentModel) {
        if (!field.hasAnnotation(Named.class)) {
            return false;
        }
        Named annotation = (Named)field.getAnnotation(Named.class);
        Class fieldType = this.cache.forName(field.getTypeName());
        Object service = this.locator.getService(annotation.value(), fieldType);
        field.inject(service);
        return true;
    }
}

