/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.Serializable;
import java.util.List;
import org.apache.tapestry.OptionGroupModel;
import org.apache.tapestry.OptionModel;
import org.apache.tapestry.SelectModel;
import org.apache.tapestry.internal.OptionModelImpl;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumSelectModel
implements SelectModel,
Serializable {
    private static final long serialVersionUID = -3590412082766899684L;
    private final List<OptionModel> _options = CollectionFactory.newList();

    public <T extends Enum> EnumSelectModel(Class<T> enumClass, Messages messages) {
        this(enumClass, messages, (Enum[])enumClass.getEnumConstants());
    }

    public <T extends Enum> EnumSelectModel(Class<T> enumClass, Messages messages, T[] values) {
        Defense.notNull(enumClass, (String)"enumClass");
        Defense.notNull((Object)messages, (String)"messages");
        String prefix = IOCUtilities.toSimpleId((String)enumClass.getName());
        for (T value : values) {
            String label = this.labelForValue(messages, prefix, (Enum)value);
            this._options.add(new OptionModelImpl(label, false, value, new String[0]));
        }
    }

    private String labelForValue(Messages messages, String prefix, Enum value) {
        String name = value.name();
        String key = prefix + "." + name;
        if (messages.contains(key)) {
            return messages.get(key);
        }
        if (messages.contains(name)) {
            return messages.get(name);
        }
        return TapestryUtils.toUserPresentable(name.toLowerCase());
    }

    @Override
    public List<OptionGroupModel> getOptionGroups() {
        return null;
    }

    @Override
    public List<OptionModel> getOptions() {
        return this._options;
    }
}

