/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.internal.TapestryAppInitializer;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.RegistryBuilder;
import org.apache.tapestry.services.HttpServletRequestHandler;
import org.apache.tapestry.services.ServletApplicationInitializer;

public class TapestryFilter
implements Filter {
    private final Log _log = LogFactory.getLog(TapestryFilter.class);
    private FilterConfig _config;
    private Registry _registry;
    private HttpServletRequestHandler _handler;

    public final void init(FilterConfig filterConfig) throws ServletException {
        this._config = filterConfig;
        String appPackage = this._config.getServletContext().getInitParameter("tapestry.app-package");
        String filterName = this._config.getFilterName();
        TapestryAppInitializer appInitializer = new TapestryAppInitializer(appPackage, filterName, "servlet");
        this._registry = appInitializer.getRegistry();
        long start = appInitializer.getStartTime();
        long toRegistry = appInitializer.getRegistryCreatedTime();
        ServletApplicationInitializer ai = (ServletApplicationInitializer)this._registry.getService("tapestry.ServletApplicationInitializer", ServletApplicationInitializer.class);
        ai.initializeApplication(filterConfig.getServletContext());
        this._handler = (HttpServletRequestHandler)this._registry.getService("tapestry.HttpServletRequestHandler", HttpServletRequestHandler.class);
        long toFinish = System.currentTimeMillis();
        this._log.info((Object)String.format("Startup time: %,d ms to build IoC Registry, %,d ms overall.", toRegistry - start, toFinish - start));
    }

    protected void addModules(RegistryBuilder builder) {
        IOCUtilities.addDefaultModules((RegistryBuilder)builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            boolean handled = this._handler.service((HttpServletRequest)request, (HttpServletResponse)response);
            if (!handled) {
                chain.doFilter(request, response);
            }
        }
        finally {
            this._registry.cleanupThread();
        }
    }

    public final void destroy() {
        this._registry.shutdown();
        this._registry = null;
        this._config = null;
        this._handler = null;
    }
}

