/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.Field;
import org.apache.tapestry.ValidationTracker;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationTrackerImpl
implements ValidationTracker,
Serializable {
    private static final long serialVersionUID = -8029192726659275677L;
    private List<String> _extraErrors;
    private List<FieldTracker> _fieldTrackers;
    private transient Map<String, FieldTracker> _fieldToTracker;

    private void refreshFieldToTracker() {
        if (this._fieldToTracker != null) {
            return;
        }
        if (this._fieldTrackers == null) {
            return;
        }
        this._fieldToTracker = CollectionFactory.newMap();
        for (FieldTracker ft : this._fieldTrackers) {
            this._fieldToTracker.put(ft.getFieldName(), ft);
        }
    }

    private FieldTracker get(Field field) {
        String key = field.getElementName();
        this.refreshFieldToTracker();
        FieldTracker result = (FieldTracker)InternalUtils.get(this._fieldToTracker, (Object)key);
        if (result == null) {
            result = new FieldTracker(key);
        }
        return result;
    }

    private void store(FieldTracker fieldTracker) {
        if (this._fieldTrackers == null) {
            this._fieldTrackers = CollectionFactory.newList();
        }
        this.refreshFieldToTracker();
        String key = fieldTracker.getFieldName();
        if (!this._fieldToTracker.containsKey(key)) {
            this._fieldTrackers.add(fieldTracker);
            this._fieldToTracker.put(key, fieldTracker);
        }
    }

    @Override
    public void clear() {
        this._extraErrors = null;
        this._fieldTrackers = null;
        this._fieldToTracker = null;
    }

    @Override
    public String getError(Field field) {
        return this.get(field).getErrorMessage();
    }

    @Override
    public List<String> getErrors() {
        List result = CollectionFactory.newList();
        if (this._extraErrors != null) {
            result.addAll(this._extraErrors);
        }
        if (this._fieldTrackers != null) {
            for (FieldTracker ft : this._fieldTrackers) {
                String errorMessage = ft.getErrorMessage();
                if (errorMessage == null) continue;
                result.add(errorMessage);
            }
        }
        return result;
    }

    @Override
    public boolean getHasErrors() {
        return !this.getErrors().isEmpty();
    }

    @Override
    public String getInput(Field field) {
        return this.get(field).getInput();
    }

    @Override
    public boolean inError(Field field) {
        return InternalUtils.isNonBlank((String)this.get(field).getErrorMessage());
    }

    @Override
    public void recordError(Field field, String errorMessage) {
        FieldTracker ft = this.get(field);
        ft.setErrorMessage(errorMessage);
        this.store(ft);
    }

    @Override
    public void recordError(String errorMessage) {
        if (this._extraErrors == null) {
            this._extraErrors = CollectionFactory.newList();
        }
        this._extraErrors.add(errorMessage);
    }

    @Override
    public void recordInput(Field field, String input) {
        FieldTracker ft = this.get(field);
        ft.setInput(input);
        this.store(ft);
    }

    private static class FieldTracker
    implements Serializable {
        private static final long serialVersionUID = -3653306147088451811L;
        private final String _fieldName;
        private String _input;
        private String _errorMessage;

        FieldTracker(String fieldName) {
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public void setErrorMessage(String errorMessage) {
            this._errorMessage = errorMessage;
        }

        public String getErrorMessage() {
            return this._errorMessage;
        }

        public String getInput() {
            return this._input;
        }

        public void setInput(String input) {
            this._input = input;
        }
    }
}

