/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.components;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.tapestry.ComponentAction;
import org.apache.tapestry.ComponentEventHandler;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Field;
import org.apache.tapestry.Link;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.ValidationTracker;
import org.apache.tapestry.ValidationTrackerImpl;
import org.apache.tapestry.annotations.AfterRender;
import org.apache.tapestry.annotations.BeginRender;
import org.apache.tapestry.annotations.CleanupRender;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.annotations.Environmental;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.annotations.Mixin;
import org.apache.tapestry.annotations.OnEvent;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.annotations.SetupRender;
import org.apache.tapestry.corelib.components.FormSupportImpl;
import org.apache.tapestry.corelib.mixins.RenderInformals;
import org.apache.tapestry.dom.Element;
import org.apache.tapestry.internal.services.FormParameterLookup;
import org.apache.tapestry.internal.services.HeartbeatImpl;
import org.apache.tapestry.internal.util.Base64ObjectInputStream;
import org.apache.tapestry.internal.util.Base64ObjectOutputStream;
import org.apache.tapestry.internal.util.Holder;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.ComponentEventResultProcessor;
import org.apache.tapestry.services.ComponentSource;
import org.apache.tapestry.services.Environment;
import org.apache.tapestry.services.FormSupport;
import org.apache.tapestry.services.Heartbeat;
import org.apache.tapestry.services.PageRenderSupport;

@ComponentClass
public class Form {
    public static final String PREPARE = "prepare";
    public static final String SUBMIT = "submit";
    public static final String VALIDATE = "validate";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    @Parameter
    private List<?> _context;
    @Parameter(value="defaultTracker")
    private ValidationTracker _tracker;
    public static final String FORM_DATA = "t:formdata";
    @Inject(value="infrastructure:Environment")
    private Environment _environment;
    @Inject
    private ComponentResources _resources;
    @Environmental
    private PageRenderSupport _pageRenderSupport;
    @Inject(value="service:tapestry.internal.FormParameterLookup")
    private FormParameterLookup _paramLookup;
    @Inject(value="infrastructure:ComponentSource")
    private ComponentSource _source;
    @Persist
    private ValidationTracker _defaultTracker;
    private FormSupportImpl _formSupport;
    private Base64ObjectOutputStream _actions;
    @Mixin
    private RenderInformals _renderInformals;
    private Element _div;
    @Inject(value="infrastructure:ComponentEventResultProcessor")
    private ComponentEventResultProcessor _eventResultProcessor;

    public ValidationTracker getDefaultTracker() {
        if (this._defaultTracker == null) {
            this._defaultTracker = new ValidationTrackerImpl();
        }
        return this._defaultTracker;
    }

    public void setDefaultTracker(ValidationTracker defaultTracker) {
        this._defaultTracker = defaultTracker;
    }

    @SetupRender
    void setup() {
        try {
            this._actions = new Base64ObjectOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this._formSupport = new FormSupportImpl(this._actions);
        this._environment.push(FormSupport.class, this._formSupport);
        this._environment.push(ValidationTracker.class, this._tracker);
    }

    @BeginRender
    void begin(MarkupWriter writer) {
        Object[] contextArray = this._context == null ? new Object[]{} : this._context.toArray();
        this._resources.triggerEvent(PREPARE, contextArray, null);
        String name = this._pageRenderSupport.allocateClientId(this._resources.getId());
        Link link = this._resources.createActionLink("action", true, contextArray);
        writer.element("form", "name", name, "id", name, "method", "post", "action", link);
        this._resources.renderInformalParameters(writer);
        this._div = writer.element("div", "class", "t-invisible");
        for (String parameterName : link.getParameterNames()) {
            String value = link.getParameterValue(parameterName);
            writer.element("input", "type", "hidden", "name", parameterName, "value", value);
            writer.end();
        }
        writer.end();
        this._environment.peek(Heartbeat.class).begin();
    }

    @AfterRender
    void after(MarkupWriter writer) {
        this._environment.peek(Heartbeat.class).end();
        this._formSupport.executeDeferred();
        writer.end();
        try {
            this._actions.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this._div.element("input", "type", "hidden", "name", FORM_DATA, "value", this._actions.toBase64());
    }

    @CleanupRender
    void cleanup() {
        this._environment.pop(FormSupport.class);
        this._formSupport = null;
        this._tracker = this._environment.pop(ValidationTracker.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnEvent(value={"action"})
    Object onSubmit(Object[] context) {
        this._tracker.clear();
        this._formSupport = new FormSupportImpl();
        this._environment.push(ValidationTracker.class, this._tracker);
        this._environment.push(FormSupport.class, this._formSupport);
        HeartbeatImpl heartbeat = new HeartbeatImpl();
        this._environment.push(Heartbeat.class, heartbeat);
        heartbeat.begin();
        try {
            ValidationTracker tracker;
            final Holder holder = Holder.create();
            ComponentEventHandler handler = new ComponentEventHandler(){

                public boolean handleResult(Object result, Component component, String methodDescription) {
                    if (result instanceof Boolean) {
                        return (Boolean)result;
                    }
                    holder.put(Form.this._eventResultProcessor.processComponentEvent(result, component, methodDescription));
                    return true;
                }
            };
            this._resources.triggerEvent(PREPARE, context, handler);
            if (holder.hasValue()) {
                Object t = holder.get();
                return t;
            }
            String actionsBase64 = this._paramLookup.getParameter(FORM_DATA);
            try {
                Base64ObjectInputStream ois = new Base64ObjectInputStream(actionsBase64);
                while (true) {
                    String componentId = ois.readUTF();
                    ComponentAction action = (ComponentAction)ois.readObject();
                    Component component = this._source.getComponent(componentId);
                    action.execute(component);
                }
            }
            catch (EOFException ex) {
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            heartbeat.end();
            this._tracker = tracker = this._environment.peek(ValidationTracker.class);
            this._resources.triggerEvent(VALIDATE, context, handler);
            if (holder.hasValue()) {
                Object t = holder.get();
                return t;
            }
            this._formSupport.executeDeferred();
            if (!this._tracker.getHasErrors()) {
                this._tracker.clear();
            }
            this._resources.triggerEvent(tracker.getHasErrors() ? FAILURE : SUCCESS, context, handler);
            if (holder.hasValue()) {
                Object t = holder.get();
                return t;
            }
            this._resources.triggerEvent(SUBMIT, context, handler);
            Object t = holder.get();
            return t;
        }
        finally {
            this._environment.pop(Heartbeat.class);
            this._environment.pop(FormSupport.class);
        }
    }

    public void recordError(String errorMessage) {
        ValidationTracker tracker = this._tracker;
        tracker.recordError(errorMessage);
        this._tracker = tracker;
    }

    public void recordError(Field field, String errorMessage) {
        ValidationTracker tracker = this._tracker;
        tracker.recordError(field, errorMessage);
        this._tracker = tracker;
    }

    public boolean getHasErrors() {
        return this._tracker.getHasErrors();
    }

    public boolean isValid() {
        return !this._tracker.getHasErrors();
    }

    void setTracker(ValidationTracker tracker) {
        this._tracker = tracker;
    }

    public void clearErrors() {
        this._tracker.clear();
    }
}

