/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.components;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry.ComponentAction;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.PrimaryKeyEncoder;
import org.apache.tapestry.annotations.AfterRender;
import org.apache.tapestry.annotations.BeginRender;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.annotations.Environmental;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.annotations.Parameter;
import org.apache.tapestry.annotations.SetupRender;
import org.apache.tapestry.annotations.SupportsInformalParameters;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.FormSupport;
import org.apache.tapestry.services.Heartbeat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentClass
@SupportsInformalParameters
public class Loop {
    private static final ComponentAction<Loop> RESET_INDEX = new ComponentAction<Loop>(){
        private static final long serialVersionUID = 6477493424977597345L;

        @Override
        public void execute(Loop component) {
            component.resetIndex();
        }
    };
    private static final ComponentAction<Loop> SETUP_FOR_VOLATILE = new ComponentAction<Loop>(){
        private static final long serialVersionUID = -977168791667037377L;

        @Override
        public void execute(Loop component) {
            component.setupForVolatile();
        }
    };
    private static final ComponentAction<Loop> ADVANCE_VOLATILE = new ComponentAction<Loop>(){
        private static final long serialVersionUID = -4600281573714776832L;

        @Override
        public void execute(Loop component) {
            component.advanceVolatile();
        }
    };
    private static final ComponentAction<Loop> END_HEARTBEAT = new ComponentAction<Loop>(){
        private static final long serialVersionUID = -977168791667037377L;

        @Override
        public void execute(Loop component) {
            component.endHeartbeat();
        }
    };
    @Parameter(required=true)
    private Iterable<?> _source;
    @Parameter
    private PrimaryKeyEncoder<Serializable, Object> _encoder;
    @Parameter
    private boolean _volatile;
    @Environmental(value=false)
    private FormSupport _formSupport;
    @Parameter(value="prop:componentResources.elementName", defaultPrefix="literal")
    private String _elementName;
    @Parameter
    private Object _value;
    @Parameter
    private int _index;
    private Iterator<?> _iterator;
    @Environmental
    private Heartbeat _heartbeat;
    private boolean _storeRenderStateInForm;
    @Inject
    private ComponentResources _resources;
    private List<Serializable> _keyList;

    @SetupRender
    boolean setup() {
        this._index = 0;
        if (this._source == null) {
            return false;
        }
        this._iterator = this._source.iterator();
        this._storeRenderStateInForm = this._formSupport != null && !this._volatile;
        boolean result = this._iterator.hasNext();
        if (this._formSupport != null && result) {
            this._formSupport.store(this, this._volatile ? SETUP_FOR_VOLATILE : RESET_INDEX);
            if (this._encoder != null) {
                this._keyList = CollectionFactory.newList();
                this._formSupport.store(this, new PrepareForKeys(this._keyList));
            }
        }
        return result;
    }

    private void prepareForKeys(List<Serializable> keys) {
        this._encoder.prepareForKeys(keys);
    }

    private void setupForVolatile() {
        this._index = 0;
        this._iterator = this._source.iterator();
    }

    private void advanceVolatile() {
        this._value = this._iterator.next();
        this.startHeartbeat();
    }

    @BeginRender
    void begin() {
        this._value = this._iterator.next();
        if (this._storeRenderStateInForm) {
            if (this._encoder == null) {
                this._formSupport.store(this, new RestoreState(this._value));
            } else {
                Serializable primaryKey = this._encoder.toKey(this._value);
                this._formSupport.store(this, new RestoreStateViaEncodedPrimaryKey(primaryKey));
            }
        }
        if (this._formSupport != null && this._volatile) {
            this._formSupport.store(this, ADVANCE_VOLATILE);
        }
        this.startHeartbeat();
    }

    private void startHeartbeat() {
        this._heartbeat.begin();
    }

    void beforeRenderBody(MarkupWriter writer) {
        if (this._elementName != null) {
            writer.element(this._elementName, new Object[0]);
            this._resources.renderInformalParameters(writer);
        }
    }

    void afterRenderBody(MarkupWriter writer) {
        if (this._elementName != null) {
            writer.end();
        }
    }

    @AfterRender
    boolean after() {
        this.endHeartbeat();
        if (this._formSupport != null) {
            this._formSupport.store(this, END_HEARTBEAT);
        }
        return this._iterator.hasNext();
    }

    private void endHeartbeat() {
        this._heartbeat.end();
        ++this._index;
    }

    private void resetIndex() {
        this._index = 0;
    }

    private void restoreState(Object storedValue) {
        this._value = storedValue;
        this.startHeartbeat();
    }

    private void restoreStateViaEncodedPrimaryKey(Serializable primaryKey) {
        Object restoredValue = this._encoder.toValue(primaryKey);
        this.restoreState(restoredValue);
    }

    int getIndex() {
        return this._index;
    }

    Object getValue() {
        return this._value;
    }

    void setSource(Iterable<?> source) {
        this._source = source;
    }

    void setHeartbeat(Heartbeat heartbeat) {
        this._heartbeat = heartbeat;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrepareForKeys
    implements ComponentAction<Loop> {
        private static final long serialVersionUID = -6515255627142956828L;
        private final List<Serializable> _keys;

        public PrepareForKeys(List<Serializable> keys) {
            this._keys = keys;
        }

        @Override
        public void execute(Loop component) {
            component.prepareForKeys(this._keys);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RestoreStateViaEncodedPrimaryKey
    implements ComponentAction<Loop> {
        private static final long serialVersionUID = -2422790241589517336L;
        private final Serializable _primaryKey;

        public RestoreStateViaEncodedPrimaryKey(Serializable primaryKey) {
            this._primaryKey = primaryKey;
        }

        @Override
        public void execute(Loop component) {
            component.restoreStateViaEncodedPrimaryKey(this._primaryKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RestoreState
    implements ComponentAction<Loop> {
        private static final long serialVersionUID = -3926831611368720764L;
        private final Object _storedValue;

        public RestoreState(Object storedValue) {
            this._storedValue = storedValue;
        }

        @Override
        public void execute(Loop component) {
            component.restoreState(this._storedValue);
        }
    }
}

