/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.corelib.pages;

import java.util.List;
import org.apache.tapestry.annotations.ComponentClass;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.ioc.services.ExceptionAnalysis;
import org.apache.tapestry.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry.ioc.services.ExceptionInfo;
import org.apache.tapestry.services.ExceptionReporter;
import org.apache.tapestry.services.Request;
import org.apache.tapestry.services.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentClass
public class ExceptionReport
implements ExceptionReporter {
    private List<ExceptionInfo> _stack;
    private ExceptionInfo _info;
    private String _propertyName;
    private String _frame;
    private String _attributeName;
    @Inject(value="service:tapestry.ioc.ExceptionAnalyzer")
    private ExceptionAnalyzer _analyzer;
    @Inject(value="infrastructure:Request")
    private Request _request;

    @Override
    public void reportException(Throwable exception) {
        ExceptionAnalysis analysis = this._analyzer.analyze(exception);
        this._stack = analysis.getExceptionInfos();
    }

    public List<ExceptionInfo> getStack() {
        return this._stack;
    }

    public ExceptionInfo getInfo() {
        return this._info;
    }

    public void setInfo(ExceptionInfo info) {
        this._info = info;
    }

    public String getFrame() {
        return this._frame;
    }

    public void setFrame(String frame) {
        this._frame = frame;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public void setPropertyName(String propertyName) {
        this._propertyName = propertyName;
    }

    public boolean getShowPropertyList() {
        return !this._info.getPropertyNames().isEmpty() || !this._info.getStackTrace().isEmpty();
    }

    public Object getPropertyValue() {
        return this._info.getProperty(this._propertyName);
    }

    public boolean getHasSession() {
        return this._request.getSession(false) != null;
    }

    public Session getSession() {
        return this._request.getSession(false);
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public void setAttributeName(String attributeName) {
        this._attributeName = attributeName;
    }

    public Object getAttributeValue() {
        return this.getSession().getAttribute(this._attributeName);
    }
}

