/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.dom;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry.dom.Element;
import org.apache.tapestry.dom.util.PrintOutCollector;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    private Node _container;
    private List<Node> _children;

    protected Node(Node container) {
        this._container = container;
    }

    public Node getContainer() {
        return this._container;
    }

    Element asElement() {
        return null;
    }

    void addChild(Node child) {
        if (this._children == null) {
            this._children = CollectionFactory.newList();
        }
        this._children.add(child);
    }

    void insertChildAt(int index, Node child) {
        if (this._children == null) {
            this._children = CollectionFactory.newList();
        }
        this._children.add(index, child);
    }

    boolean hasChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    void writeChildMarkup(PrintWriter writer) {
        if (this._children == null) {
            return;
        }
        for (Node child : this._children) {
            child.toMarkup(writer);
        }
    }

    public String getChildText() {
        PrintOutCollector collector = new PrintOutCollector();
        this.writeChildMarkup(collector.getPrintWriter());
        return collector.getPrintOut();
    }

    public String toString() {
        PrintOutCollector collector = new PrintOutCollector();
        this.toMarkup(collector.getPrintWriter());
        return collector.getPrintOut();
    }

    public List<Node> getChildren() {
        return this._children == null ? Collections.EMPTY_LIST : this._children;
    }

    public abstract void toMarkup(PrintWriter var1);
}

