/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal;

import java.util.Map;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.Registry;
import org.apache.tapestry.ioc.RegistryBuilder;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.services.ComponentClassResolver;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.services.TapestryModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapestryAppInitializer {
    private String _appPackage;
    private String _appName;
    private String _infrastructureMode;
    private Registry _registry;
    private long _startTime;
    private long _registryCreatedTime;
    private final Map<String, Object> _serviceOverrides;

    public TapestryAppInitializer(String appPackage, String appName, String infrastructureMode) {
        this(appPackage, appName, infrastructureMode, null);
    }

    public TapestryAppInitializer(String appPackage, String appName, String infrastructureMode, Map<String, Object> serviceOverrides) {
        this._appPackage = appPackage;
        this._appName = appName;
        this._infrastructureMode = infrastructureMode;
        this._serviceOverrides = serviceOverrides;
        this._startTime = System.currentTimeMillis();
        this.createRegistry();
        this._registryCreatedTime = System.currentTimeMillis();
        this.setupServices();
    }

    private void createRegistry() {
        RegistryBuilder builder = new RegistryBuilder();
        builder.add(new Class[]{TapestryModule.class});
        String className = this._appPackage + ".services." + InternalUtils.capitalize((String)this._appName) + "Module";
        try {
            Class<?> moduleClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            builder.add(new Class[]{moduleClass});
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.addModules(builder);
        this.overrideServices(builder);
        this._registry = builder.build();
    }

    private void overrideServices(RegistryBuilder builder) {
        if (this._serviceOverrides != null) {
            for (Map.Entry<String, Object> e : this._serviceOverrides.entrySet()) {
                builder.addServiceOverride(e.getKey(), e.getValue());
            }
        }
    }

    private void setupServices() {
        Infrastructure infra = (Infrastructure)this._registry.getService("tapestry.Infrastructure", Infrastructure.class);
        infra.setMode(this._infrastructureMode);
        ComponentClassResolver resolver = (ComponentClassResolver)this._registry.getService("tapestry.ComponentClassResolver", ComponentClassResolver.class);
        resolver.setApplicationPackage(this._appPackage);
    }

    protected void addModules(RegistryBuilder builder) {
        IOCUtilities.addDefaultModules((RegistryBuilder)builder);
    }

    public Registry getRegistry() {
        return this._registry;
    }

    public long getRegistryCreatedTime() {
        return this._registryCreatedTime;
    }

    public long getStartTime() {
        return this._startTime;
    }
}

