/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.OptionModel;
import org.apache.tapestry.SelectModel;
import org.apache.tapestry.internal.InternalMessages;
import org.apache.tapestry.internal.KeyValue;
import org.apache.tapestry.internal.OptionModelImpl;
import org.apache.tapestry.internal.SelectModelImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapestryUtils {
    private TapestryUtils() {
    }

    public static final void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String decapitalize(String input) {
        char first = input.charAt(0);
        return Character.toLowerCase(first) + input.substring(1);
    }

    public static String toUserPresentable(String id) {
        StringBuilder builder = new StringBuilder(id.length() * 2);
        char[] chars = id.toCharArray();
        boolean postSpace = true;
        boolean upcaseNext = true;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (upcaseNext) {
                builder.append(Character.toUpperCase(ch));
                upcaseNext = false;
                continue;
            }
            if (ch == '_') {
                builder.append(' ');
                upcaseNext = true;
                continue;
            }
            boolean upperCase = Character.isUpperCase(ch);
            if (upperCase && !postSpace) {
                builder.append(' ');
            }
            builder.append(ch);
            postSpace = upperCase;
        }
        return builder.toString();
    }

    public static Map<String, String> mapFromKeysAndValues(String ... keysAndValues) {
        Map result = CollectionFactory.newMap();
        int i = 0;
        while (i < keysAndValues.length) {
            String key = keysAndValues[i++];
            String value = keysAndValues[i++];
            result.put(key, value);
        }
        return result;
    }

    public static OptionModel toOptionModel(String input) {
        Defense.notNull((Object)input, (String)"input");
        int equalsx = input.indexOf(61);
        if (equalsx < 0) {
            return new OptionModelImpl(input, false, (Object)input, new String[0]);
        }
        String value = input.substring(0, equalsx);
        String label = input.substring(equalsx + 1);
        return new OptionModelImpl(label, false, (Object)value, new String[0]);
    }

    public static List<OptionModel> toOptionModels(String input) {
        Defense.notNull((Object)input, (String)"input");
        List result = CollectionFactory.newList();
        for (String term : input.split(",")) {
            result.add(TapestryUtils.toOptionModel(term.trim()));
        }
        return result;
    }

    public static SelectModel toSelectModel(String input) {
        List<OptionModel> options = TapestryUtils.toOptionModels(input);
        return new SelectModelImpl(null, options);
    }

    public static KeyValue parseKeyValue(String input) {
        int pos = input.indexOf(61);
        if (pos < 1) {
            throw new IllegalArgumentException(InternalMessages.badKeyValue(input));
        }
        String key = input.substring(0, pos);
        String value = input.substring(pos + 1);
        return new KeyValue(key.trim(), value.trim());
    }
}

