/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.bindings;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry.AnnotationProvider;
import org.apache.tapestry.Binding;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.internal.bindings.BasePropBinding;
import org.apache.tapestry.internal.bindings.BindingsMessages;
import org.apache.tapestry.internal.bindings.PropBindingAnnotationProvider;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.TapestryException;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.apache.tapestry.ioc.services.PropertyAccess;
import org.apache.tapestry.ioc.services.PropertyAdapter;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.BindingFactory;

public class PropBindingFactory
implements BindingFactory,
InvalidationListener {
    private static final String PARENS = "()";
    private final PropertyAccess _access;
    private final ClassFactory _classFactory;
    private final Map<String, BindingConstructor> _cache = CollectionFactory.newThreadSafeMap();
    private static final MethodSignature GET_SIGNATURE = new MethodSignature(Object.class, "get", null, null);
    private static final MethodSignature SET_SIGNATURE = new MethodSignature(Void.TYPE, "set", new Class[]{Object.class}, null);

    public PropBindingFactory(PropertyAccess propertyAccess, ClassFactory classFactory) {
        this._access = propertyAccess;
        this._classFactory = classFactory;
    }

    public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
        Component target = container.getComponent();
        Class<?> targetClass = target.getClass();
        try {
            BindingConstructor cons = this.findCachedConstructor(targetClass, expression);
            String toString = String.format("PropBinding[%s %s(%s)]", description, container.getCompleteId(), expression);
            return cons.newBindingInstance(target, toString, location);
        }
        catch (Throwable ex) {
            throw new TapestryException(ex.getMessage(), location, ex);
        }
    }

    private BindingConstructor findCachedConstructor(Class targetClass, String propertyName) {
        String key = targetClass.getName() + ":" + propertyName;
        BindingConstructor result = this._cache.get(key);
        if (result == null) {
            result = this.createConstructor(key, targetClass, propertyName);
            this._cache.put(key, result);
        }
        return result;
    }

    private BindingConstructor createConstructor(String key, Class targetClass, String propertyExpression) {
        StringBuilder builder = new StringBuilder("_target");
        Class step = targetClass;
        String[] terms = propertyExpression.split("\\.");
        for (int i = 0; i < terms.length - 1; ++i) {
            String term = terms[i];
            boolean isMethodReference = term.endsWith(PARENS);
            step = isMethodReference ? this.extendWithMethodTerm(step, term, propertyExpression, builder) : this.extendWithPropertyTerm(step, term, propertyExpression, builder);
        }
        String terminal = terms[terms.length - 1];
        Class bindingType = null;
        Method readMethod = null;
        Method writeMethod = null;
        if (terminal.endsWith(PARENS)) {
            readMethod = this.validateMethodName(step, terminal, propertyExpression);
            bindingType = readMethod.getReturnType();
        } else {
            PropertyAdapter adapter = this._access.getAdapter(step).getPropertyAdapter(terminal);
            if (adapter == null) {
                throw new RuntimeException(BindingsMessages.noSuchProperty(step, terminal, propertyExpression));
            }
            bindingType = adapter.getType();
            readMethod = adapter.getReadMethod();
            writeMethod = adapter.getWriteMethod();
        }
        Class bindingClass = this.createBindingClass(targetClass, builder.toString(), terminal, bindingType, readMethod, writeMethod);
        return new BindingConstructor(bindingType, new PropBindingAnnotationProvider(readMethod, writeMethod), bindingClass.getConstructors()[0]);
    }

    private Class extendWithMethodTerm(Class inClass, String term, String propertyExpression, StringBuilder builder) {
        Method method = this.validateMethodName(inClass, term, propertyExpression);
        builder.append(".");
        builder.append(term);
        return method.getReturnType();
    }

    private Method validateMethodName(Class inClass, String term, String propertyExpression) {
        String methodName = term.substring(0, term.length() - PARENS.length());
        try {
            Method method = inClass.getMethod(methodName, new Class[0]);
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new RuntimeException(BindingsMessages.methodIsVoid(term, inClass, propertyExpression));
            }
            return method;
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(BindingsMessages.methodNotFound(term, inClass, propertyExpression), ex);
        }
    }

    private Class extendWithPropertyTerm(Class inClass, String term, String propertyExpression, StringBuilder builder) {
        PropertyAdapter pa = this._access.getAdapter(inClass).getPropertyAdapter(term);
        if (pa == null) {
            throw new RuntimeException(BindingsMessages.noSuchProperty(inClass, term, propertyExpression));
        }
        Method m = pa.getReadMethod();
        if (m == null) {
            throw new RuntimeException(BindingsMessages.writeOnlyProperty(term, inClass, propertyExpression));
        }
        builder.append(".");
        builder.append(m.getName());
        builder.append(PARENS);
        return pa.getType();
    }

    private Class createBindingClass(Class targetClass, String pathExpression, String propertyName, Class propertyType, Method readMethod, Method writeMethod) {
        String name = ClassFabUtils.generateClassName((String)"PropBinding");
        ClassFab classFab = this._classFactory.newClass(name, BasePropBinding.class);
        classFab.addField("_target", targetClass);
        classFab.addConstructor(new Class[]{targetClass, Class.class, String.class, AnnotationProvider.class, Location.class}, null, "{ super($2, $3, $4, $5); _target = $1; }");
        if (readMethod != null) {
            String body = String.format("return ($w) %s.%s();", pathExpression, readMethod.getName());
            classFab.addMethod(1, GET_SIGNATURE, body);
        }
        if (writeMethod != null) {
            BodyBuilder builder = new BodyBuilder();
            builder.begin();
            String propertyTypeName = propertyType.getName();
            builder.add("%s value = ", new Object[]{propertyTypeName});
            if (propertyType.isPrimitive()) {
                String wrapperType = ClassFabUtils.getWrapperTypeName((String)propertyTypeName);
                String unwrapMethod = ClassFabUtils.getUnwrapMethodName((String)propertyTypeName);
                builder.addln("((%s) $1).%s();", new Object[]{wrapperType, unwrapMethod});
            } else {
                builder.addln("(%s) $1;", new Object[]{propertyTypeName});
            }
            builder.addln("%s.%s(value);", new Object[]{pathExpression, writeMethod.getName()});
            builder.end();
            classFab.addMethod(1, SET_SIGNATURE, builder.toString());
        }
        return classFab.createClass();
    }

    public void objectWasInvalidated() {
        this._cache.clear();
    }

    private static class BindingConstructor {
        private final Class _propertyType;
        private final Constructor _constructor;
        private final AnnotationProvider _annotationProvider;

        BindingConstructor(Class propertyType, AnnotationProvider annotationProvider, Constructor constructor) {
            this._propertyType = propertyType;
            this._constructor = constructor;
            this._annotationProvider = annotationProvider;
        }

        Binding newBindingInstance(Object target, String toString, Location location) throws Exception {
            return (Binding)this._constructor.newInstance(target, this._propertyType, toString, this._annotationProvider, location);
        }
    }
}

