/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Map;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.ApplicationStateContribution;
import org.apache.tapestry.services.ApplicationStateCreator;
import org.apache.tapestry.services.ApplicationStateManager;
import org.apache.tapestry.services.ApplicationStatePersistenceStrategy;
import org.apache.tapestry.services.ApplicationStatePersistenceStrategySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationStateManagerImpl
implements ApplicationStateManager {
    static final String DEFAULT_STRATEGY = "session";
    private final Map<Class, ApplicationStateAdapter> _classToAdapter = CollectionFactory.newThreadSafeMap();
    private final ApplicationStatePersistenceStrategySource _source;

    public ApplicationStateManagerImpl(Map<Class, ApplicationStateContribution> configuration, ApplicationStatePersistenceStrategySource source) {
        this._source = source;
        for (Class asoClass : configuration.keySet()) {
            ApplicationStateContribution contribution = configuration.get(asoClass);
            ApplicationStateAdapter adapter = this.newAdapter(asoClass, contribution.getStrategy(), contribution.getCreator());
            this._classToAdapter.put(asoClass, adapter);
        }
    }

    private <T> ApplicationStateAdapter<T> newAdapter(final Class<T> asoClass, String strategyName, ApplicationStateCreator<T> creator) {
        if (creator == null) {
            creator = new ApplicationStateCreator<T>(){

                @Override
                public T create() {
                    try {
                        return asoClass.newInstance();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }
        ApplicationStatePersistenceStrategy strategy = this._source.get(strategyName);
        return new ApplicationStateAdapter<T>(asoClass, strategy, creator);
    }

    private <T> ApplicationStateAdapter<T> getAdapter(Class<T> asoClass) {
        ApplicationStateAdapter<T> result = this._classToAdapter.get(asoClass);
        if (result == null) {
            result = this.newAdapter(asoClass, DEFAULT_STRATEGY, null);
            this._classToAdapter.put(asoClass, result);
        }
        return result;
    }

    @Override
    public <T> T get(Class<T> asoClass) {
        return this.getAdapter(asoClass).getOrCreate();
    }

    @Override
    public <T> void set(Class<T> asoClass, T aso) {
        this.getAdapter(asoClass).set(aso);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplicationStateAdapter<T> {
        private final Class<T> _asoClass;
        private final ApplicationStatePersistenceStrategy _strategy;
        private final ApplicationStateCreator<T> _creator;

        ApplicationStateAdapter(Class<T> asoClass, ApplicationStatePersistenceStrategy strategy, ApplicationStateCreator<T> creator) {
            this._asoClass = asoClass;
            this._strategy = strategy;
            this._creator = creator;
        }

        T getOrCreate() {
            return this._strategy.get(this._asoClass, this._creator);
        }

        void set(T aso) {
            this._strategy.set(this._asoClass, aso);
        }
    }
}

