/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.annotations.ApplicationState;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ApplicationStateManager;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.MethodSignature;

public class ApplicationStateWorker
implements ComponentClassTransformWorker {
    private final ApplicationStateManager _applicationStateManager;
    private final ClassLoader _classLoader = Thread.currentThread().getContextClassLoader();

    public ApplicationStateWorker(ApplicationStateManager applicationStateManager) {
        this._applicationStateManager = applicationStateManager;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> names = transformation.findFieldsWithAnnotation(ApplicationState.class);
        if (names.isEmpty()) {
            return;
        }
        String managerFieldName = transformation.addInjectedField(ApplicationStateManager.class, "applicationStateManager", this._applicationStateManager);
        for (String fieldName : names) {
            String fieldType = transformation.getFieldType(fieldName);
            Class<?> fieldClass = null;
            try {
                fieldClass = this._classLoader.loadClass(fieldType);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            String typeField = transformation.addInjectedField(Class.class, fieldName + "_type", fieldClass);
            this.replaceRead(transformation, fieldName, fieldType, managerFieldName, typeField);
            this.replaceWrite(transformation, fieldName, fieldType, managerFieldName, typeField);
            transformation.removeField(fieldName);
        }
    }

    private void replaceWrite(ClassTransformation transformation, String fieldName, String fieldType, String managerFieldName, String typeField) {
        String writeMethodName = transformation.newMemberName("write_" + InternalUtils.stripMemberPrefix((String)fieldName));
        MethodSignature writeSignature = new MethodSignature(2, "void", writeMethodName, new String[]{fieldType}, null);
        String body = String.format("%s.set(%s, $1);", managerFieldName, typeField);
        transformation.addMethod(writeSignature, body);
        transformation.replaceWriteAccess(fieldName, writeMethodName);
    }

    private void replaceRead(ClassTransformation transformation, String fieldName, String fieldType, String managerFieldName, String typeField) {
        String readMethodName = transformation.newMemberName("read_" + InternalUtils.stripMemberPrefix((String)fieldName));
        MethodSignature readMethodSignature = new MethodSignature(2, fieldType, readMethodName, null, null);
        String body = String.format("return (%s) %s.get(%s);", fieldType, managerFieldName, typeField);
        transformation.addMethod(readMethodSignature, body);
        transformation.replaceReadAccess(fieldName, readMethodName);
    }
}

