/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Locale;
import java.util.Map;
import org.apache.tapestry.Asset;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.util.StrategyRegistry;
import org.apache.tapestry.services.AssetFactory;
import org.apache.tapestry.services.AssetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetSourceImpl
implements AssetSource {
    private final StrategyRegistry<AssetFactory> _registry;
    private final Map<String, Resource> _prefixToRootResource = CollectionFactory.newMap();
    private final Map<Resource, Asset> _cache = CollectionFactory.newThreadSafeMap();

    public AssetSourceImpl(Map<String, AssetFactory> configuration) {
        Map byResourceClass = CollectionFactory.newMap();
        for (Map.Entry<String, AssetFactory> e : configuration.entrySet()) {
            String prefix = e.getKey();
            AssetFactory factory = e.getValue();
            Resource rootResource = factory.getRootResource();
            byResourceClass.put(rootResource.getClass(), factory);
            this._prefixToRootResource.put(prefix, rootResource);
        }
        this._registry = StrategyRegistry.newInstance(AssetFactory.class, (Map)byResourceClass);
    }

    @Override
    public Asset getClasspathAsset(String path, Locale locale) {
        Resource baseResource = this._prefixToRootResource.get("classpath");
        return this.findAsset(baseResource, path, locale);
    }

    @Override
    public Asset findAsset(Resource baseResource, String path, Locale locale) {
        Defense.notNull((Object)baseResource, (String)"baseResource");
        Defense.notBlank((String)path, (String)"path");
        Defense.notNull((Object)locale, (String)"locale");
        int colonx = path.indexOf(58);
        if (colonx < 0) {
            return this.findRelativeAsset(baseResource, path, locale);
        }
        String prefix = path.substring(0, colonx);
        Resource rootResource = this._prefixToRootResource.get(prefix);
        if (rootResource == null) {
            throw new IllegalArgumentException(ServicesMessages.unknownAssetPrefix(path));
        }
        return this.findRelativeAsset(rootResource, path.substring(colonx + 1), locale);
    }

    private Asset findRelativeAsset(Resource baseResource, String path, Locale locale) {
        Resource unlocalized = baseResource.forFile(path);
        Resource localized = unlocalized.forLocale(locale);
        if (localized == null) {
            throw new RuntimeException(ServicesMessages.assetDoesNotExist(unlocalized));
        }
        return this.getAssetForResource(localized);
    }

    private Asset getAssetForResource(Resource resource) {
        Asset result = this._cache.get(resource);
        if (result == null) {
            result = this.createAssetFromResource(resource);
            this._cache.put(resource, result);
        }
        return result;
    }

    private Asset createAssetFromResource(Resource resource) {
        Class<?> resourceClass = resource.getClass();
        AssetFactory factory = (AssetFactory)this._registry.get(resourceClass);
        return factory.createAsset(resource);
    }
}

