/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.ClasspathAssetAliasManager;
import org.apache.tapestry.services.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathAssetAliasManagerImpl
implements ClasspathAssetAliasManager {
    private final Request _request;
    private final Map<String, String> _aliasToPathPrefix;
    private final Map<String, String> _pathPrefixToAlias = CollectionFactory.newMap();
    private final List<String> _sortedAliases;
    private final List<String> _sortedPathPrefixes;

    public ClasspathAssetAliasManagerImpl(Request request, Map<String, String> configuration) {
        this._request = request;
        this._aliasToPathPrefix = configuration;
        for (Map.Entry<String, String> e : this._aliasToPathPrefix.entrySet()) {
            this._pathPrefixToAlias.put(e.getValue(), e.getKey());
        }
        Comparator<String> sortDescendingByLength = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        };
        this._sortedAliases = CollectionFactory.newList(this._aliasToPathPrefix.keySet());
        Collections.sort(this._sortedAliases, sortDescendingByLength);
        this._sortedPathPrefixes = CollectionFactory.newList(this._aliasToPathPrefix.values());
        Collections.sort(this._sortedPathPrefixes, sortDescendingByLength);
    }

    @Override
    public String toClientURL(String resourcePath) {
        StringBuilder builder = new StringBuilder(this._request.getContextPath());
        builder.append("/assets/");
        for (String pathPrefix : this._sortedPathPrefixes) {
            if (!resourcePath.startsWith(pathPrefix)) continue;
            String alias = this._pathPrefixToAlias.get(pathPrefix);
            builder.append(alias);
            builder.append(resourcePath.substring(pathPrefix.length()));
            return builder.toString();
        }
        builder.append(resourcePath);
        return builder.toString();
    }

    @Override
    public String toResourcePath(String clientURL) {
        String basePath = clientURL.substring("/assets/".length());
        for (String alias : this._sortedAliases) {
            if (!basePath.startsWith(alias)) continue;
            return this._aliasToPathPrefix.get(alias) + basePath.substring(alias.length());
        }
        return basePath;
    }
}

