/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.internal.services.ComponentClassLocator;
import org.apache.tapestry.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.ComponentClassResolver;
import org.apache.tapestry.services.LibraryMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentClassResolverImpl
implements ComponentClassResolver,
InvalidationListener {
    private static final String MIXINS_SUBPACKAGE = "mixins";
    private static final String COMPONENTS_SUBPACKAGE = "components";
    private static final String PAGES_SUBPACKAGE = "pages";
    private final ComponentInstantiatorSource _componentInstantiatorSource;
    private final ComponentClassLocator _componentClassLocator;
    private String _appRootPackage;
    private final Map<String, List<String>> _mappings = CollectionFactory.newMap();
    private boolean _rebuild = true;
    private final Map<String, String> _pageToClassName = CollectionFactory.newMap();
    private final Map<String, String> _componentToClassName = CollectionFactory.newMap();
    private final Map<String, String> _mixinToClassName = CollectionFactory.newMap();
    private final Map<String, String> _pageClassNameToLogicalName = CollectionFactory.newMap();

    public ComponentClassResolverImpl(ComponentInstantiatorSource componentInstantiatorSource, ComponentClassLocator componentClassLocator, Collection<LibraryMapping> mappings) {
        this._componentInstantiatorSource = componentInstantiatorSource;
        this._componentClassLocator = componentClassLocator;
        for (LibraryMapping mapping : mappings) {
            String prefix = mapping.getPathPrefix();
            String rootPackage = mapping.getRootPackage();
            List packages = this._mappings.get(prefix);
            if (packages == null) {
                packages = CollectionFactory.newList();
                this._mappings.put(prefix, packages);
            }
            packages.add(rootPackage);
            this.addPackagesToInstantiatorSource(rootPackage);
        }
    }

    private void addPackagesToInstantiatorSource(String rootPackage) {
        this._componentInstantiatorSource.addPackage(rootPackage + ".pages");
        this._componentInstantiatorSource.addPackage(rootPackage + ".components");
        this._componentInstantiatorSource.addPackage(rootPackage + ".mixins");
        this._componentInstantiatorSource.addPackage(rootPackage + ".base");
    }

    @Override
    public synchronized void objectWasInvalidated() {
        this._rebuild = true;
        this._pageToClassName.clear();
        this._componentToClassName.clear();
        this._mixinToClassName.clear();
        this._pageClassNameToLogicalName.clear();
    }

    private synchronized void rebuild() {
        if (!this._rebuild) {
            return;
        }
        this.rebuild("", this._appRootPackage);
        for (String prefix : this._mappings.keySet()) {
            List<String> packages = this._mappings.get(prefix);
            String folder = prefix + "/";
            for (String packageName : packages) {
                this.rebuild(folder, packageName);
            }
        }
        this._rebuild = false;
    }

    private void rebuild(String pathPrefix, String rootPackage) {
        this.fillCaselessMap(pathPrefix, rootPackage, PAGES_SUBPACKAGE, this._pageToClassName);
        this.fillCaselessMap(pathPrefix, rootPackage, COMPONENTS_SUBPACKAGE, this._componentToClassName);
        this.fillCaselessMap(pathPrefix, rootPackage, MIXINS_SUBPACKAGE, this._mixinToClassName);
    }

    private void fillCaselessMap(String pathPrefix, String rootPackage, String subPackage, Map<String, String> logicalNameToClassName) {
        String searchPackage = rootPackage + "." + subPackage;
        boolean isPage = subPackage.equals(PAGES_SUBPACKAGE);
        Collection<String> classNames = this._componentClassLocator.locateComponentClassNames(searchPackage);
        int startPos = searchPackage.length() + 1;
        for (String name : classNames) {
            String withinPackage = name.substring(startPos).replace('.', '/');
            String logicalName = pathPrefix + withinPackage;
            if (isPage) {
                this._pageClassNameToLogicalName.put(name, logicalName);
            }
            logicalNameToClassName.put(logicalName.toLowerCase(), name);
        }
    }

    @Override
    public String resolvePageNameToClassName(String pageName) {
        String result = this.locate(pageName, this._pageToClassName);
        if (result == null) {
            throw new IllegalArgumentException(ServicesMessages.couldNotResolvePageName(pageName));
        }
        return result;
    }

    @Override
    public boolean isPageName(String pageName) {
        return this.locate(pageName, this._pageToClassName) != null;
    }

    @Override
    public String resolveComponentTypeToClassName(String componentType) {
        String result = this.locate(componentType, this._componentToClassName);
        if (result == null) {
            throw new IllegalArgumentException(ServicesMessages.couldNotResolveComponentType(componentType));
        }
        return result;
    }

    @Override
    public String resolveMixinTypeToClassName(String mixinType) {
        String result = this.locate(mixinType, this._mixinToClassName);
        if (result == null) {
            throw new IllegalArgumentException(ServicesMessages.couldNotResolveMixinType(mixinType));
        }
        return result;
    }

    private String locate(String logicalName, Map<String, String> logicalNameToClassName) {
        this.rebuild();
        String key = logicalName.toLowerCase();
        String result = logicalNameToClassName.get(key);
        if (result == null) {
            result = logicalNameToClassName.get("core/" + key);
        }
        return result;
    }

    @Override
    public String resolvePageClassNameToPageName(String pageClassName) {
        this.rebuild();
        String result = this._pageClassNameToLogicalName.get(pageClassName);
        if (result == null) {
            throw new IllegalArgumentException(ServicesMessages.pageNameUnresolved(pageClassName));
        }
        return result;
    }

    @Override
    public void setApplicationPackage(String packageName) {
        this._appRootPackage = packageName;
        this.addPackagesToInstantiatorSource(packageName);
    }
}

