/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.internal.util.MethodInvocationBuilder;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.MethodFilter;
import org.apache.tapestry.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentLifecycleMethodWorker
implements ComponentClassTransformWorker {
    private static final String CHECK_ABORT_FLAG = "if ($2.isAborted()) return;";
    private final Class<? extends Annotation> _methodAnnotation;
    private final MethodSignature _lifecycleMethodSignature;
    private final String _lifecycleMethodName;
    private final boolean _reverse;
    private final MethodInvocationBuilder _invocationBuilder = new MethodInvocationBuilder();

    public ComponentLifecycleMethodWorker(MethodSignature lifecycleMethodSignature, Class<? extends Annotation> methodAnnotation, boolean reverse) {
        this._lifecycleMethodSignature = lifecycleMethodSignature;
        this._methodAnnotation = methodAnnotation;
        this._reverse = reverse;
        this._lifecycleMethodName = lifecycleMethodSignature.getMethodName();
        this._invocationBuilder.addParameter(MarkupWriter.class.getName(), "$1");
    }

    public String toString() {
        return String.format("ComponentLifecycleMethodWorker[%s]", this._methodAnnotation.getName());
    }

    @Override
    public void transform(final ClassTransformation transformation, MutableComponentModel model) {
        Iterator<MethodSignature> i;
        MethodFilter filter = new MethodFilter(){

            public boolean accept(MethodSignature signature) {
                if (signature.equals(ComponentLifecycleMethodWorker.this._lifecycleMethodSignature)) {
                    return false;
                }
                return signature.getMethodName().equals(ComponentLifecycleMethodWorker.this._lifecycleMethodName) || transformation.getMethodAnnotation(signature, ComponentLifecycleMethodWorker.this._methodAnnotation) != null;
            }
        };
        List<MethodSignature> methods = transformation.findMethods(filter);
        if (methods.isEmpty()) {
            return;
        }
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        if (!this._reverse && !model.isRootClass()) {
            builder.addln("super.%s($$);", new Object[]{this._lifecycleMethodName});
            builder.addln(CHECK_ABORT_FLAG, new Object[0]);
        }
        Iterator<MethodSignature> iterator = i = this._reverse ? InternalUtils.reverseIterator(methods) : methods.iterator();
        while (i.hasNext()) {
            this.addMethodCallToBody(builder, i.next(), transformation);
        }
        if (this._reverse && !model.isRootClass()) {
            builder.addln("super.%s($$);", new Object[]{this._lifecycleMethodName});
        }
        builder.end();
        transformation.addMethod(this._lifecycleMethodSignature, builder.toString());
    }

    private void addMethodCallToBody(BodyBuilder builder, MethodSignature sig, ClassTransformation transformation) {
        boolean isVoid = sig.getReturnType().equals("void");
        if (!isVoid) {
            builder.addln("$2.setSource(this, \"%s.%s\");", new Object[]{transformation.getClassName(), sig.getMediumDescription()});
            builder.add("if ($2.storeResult(($w) ", new Object[0]);
        }
        builder.add(this._invocationBuilder.buildMethodInvocation(sig, transformation), new Object[0]);
        if (!isVoid) {
            builder.addln(")) return;", new Object[0]);
        } else {
            builder.addln(";", new Object[0]);
        }
    }
}

