/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Locale;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.events.UpdateListener;
import org.apache.tapestry.internal.services.MessagesBundle;
import org.apache.tapestry.internal.services.MessagesSource;
import org.apache.tapestry.internal.services.MessagesSourceImpl;
import org.apache.tapestry.internal.util.URLChangeTracker;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.services.ComponentMessagesSource;

public class ComponentMessagesSourceImpl
implements ComponentMessagesSource,
UpdateListener {
    private final MessagesSource _messagesSource;

    public ComponentMessagesSourceImpl() {
        this(new URLChangeTracker());
    }

    ComponentMessagesSourceImpl(URLChangeTracker tracker) {
        this._messagesSource = new MessagesSourceImpl(tracker);
    }

    public void checkForUpdates() {
        this._messagesSource.checkForUpdates();
    }

    public Messages getMessages(ComponentModel componentModel, Locale locale) {
        ComponentModelBundle bundle = new ComponentModelBundle(componentModel);
        return this._messagesSource.getMessages(bundle, locale);
    }

    public void addInvalidationListener(InvalidationListener listener) {
        this._messagesSource.addInvalidationListener(listener);
    }

    private static class ComponentModelBundle
    implements MessagesBundle {
        private final ComponentModel _model;

        public ComponentModelBundle(ComponentModel model) {
            this._model = model;
        }

        public Resource getBaseResource() {
            return this._model.getBaseResource();
        }

        public Object getId() {
            return this._model.getComponentClassName();
        }

        public MessagesBundle getParent() {
            ComponentModel parentModel = this._model.getParentModel();
            return parentModel != null ? new ComponentModelBundle(parentModel) : null;
        }
    }
}

