/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.internal.services.RequestPageCache;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.ComponentSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSourceImpl
implements ComponentSource {
    private final RequestPageCache _pageCache;

    public ComponentSourceImpl(RequestPageCache pageCache) {
        this._pageCache = pageCache;
    }

    @Override
    public Component getComponent(String componentId) {
        int colonx = componentId.indexOf(58);
        if (colonx < 0) {
            Page page = this._pageCache.getByClassName(componentId);
            return page.getRootComponent();
        }
        String pageName = componentId.substring(0, colonx);
        Page page = this._pageCache.getByClassName(pageName);
        String nestedId = componentId.substring(colonx + 1);
        return page.getComponentElementByNestedId(nestedId).getComponent();
    }

    @Override
    public <T> T getPage(Class<T> pageClass) {
        Defense.notNull(pageClass, (String)"pageClass");
        Page page = this._pageCache.getByClassName(pageClass.getName());
        Component root = page.getRootComponent();
        return pageClass.cast(root);
    }

    @Override
    public Component getPage(String pageName) {
        Page page = this._pageCache.get(pageName);
        return page.getRootComponent();
    }
}

