/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.Asset;
import org.apache.tapestry.internal.services.ContextResource;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.services.AssetFactory;
import org.apache.tapestry.services.Context;
import org.apache.tapestry.services.Request;

public class ContextAssetFactory
implements AssetFactory {
    private final Request _request;
    private final Context _context;

    public ContextAssetFactory(Request request, Context context) {
        this._request = request;
        this._context = context;
    }

    public Asset createAsset(final Resource resource) {
        final String contextPath = this._request.getContextPath() + "/" + resource.getPath();
        return new Asset(){

            public Resource getResource() {
                return resource;
            }

            public String toClientURL() {
                return contextPath;
            }

            public String toString() {
                return this.toClientURL();
            }
        };
    }

    public Resource getRootResource() {
        return new ContextResource(this._context, "/");
    }
}

