/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentImpl
implements Environment {
    private final Map<Class, LinkedList> _stacks = CollectionFactory.newMap();

    private <T> LinkedList<T> stackFor(Class<T> type) {
        LinkedList result = this._stacks.get(type);
        if (result == null) {
            result = CollectionFactory.newLinkedList();
            this._stacks.put(type, result);
        }
        return result;
    }

    @Override
    public <T> T peek(Class<T> type) {
        LinkedList<T> stack = this.stackFor(type);
        return stack.isEmpty() ? null : (T)stack.getFirst();
    }

    @Override
    public <T> T peekRequired(Class<T> type) {
        T result = this.peek(type);
        if (result == null) {
            List types = CollectionFactory.newList();
            for (Map.Entry<Class, LinkedList> e : this._stacks.entrySet()) {
                LinkedList list = e.getValue();
                if (list == null || list.isEmpty()) continue;
                types.add(e.getKey());
            }
            throw new RuntimeException(ServicesMessages.missingFromEnvironment(type, types));
        }
        return result;
    }

    @Override
    public <T> T pop(Class<T> type) {
        LinkedList<T> stack = this.stackFor(type);
        return stack.removeFirst();
    }

    @Override
    public <T> T push(Class<T> type, T instance) {
        LinkedList<T> stack = this.stackFor(type);
        T result = stack.isEmpty() ? null : (T)stack.getFirst();
        stack.addFirst(instance);
        return result;
    }

    @Override
    public void clear() {
        this._stacks.clear();
    }
}

