/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.annotations.Environmental;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.Environment;
import org.apache.tapestry.services.MethodSignature;

public class EnvironmentalWorker
implements ComponentClassTransformWorker {
    private final Environment _environment;

    public EnvironmentalWorker(Environment environment) {
        this._environment = environment;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> names = transformation.findFieldsWithAnnotation(Environmental.class);
        if (names.isEmpty()) {
            return;
        }
        String envField = transformation.addInjectedField(Environment.class, "environment", this._environment);
        for (String name : names) {
            Environmental annotation = transformation.getFieldAnnotation(name, Environmental.class);
            String type = transformation.getFieldType(name);
            String methodName = transformation.newMemberName("environment_read_" + InternalUtils.stripMemberPrefix((String)name));
            MethodSignature sig = new MethodSignature(2, type, methodName, null, null);
            String body = String.format("return ($r) %s.%s($type);", envField, annotation.value() ? "peekRequired" : "peek");
            transformation.addMethod(sig, body);
            transformation.replaceReadAccess(name, methodName);
            transformation.makeReadOnly(name);
            transformation.removeField(name);
            transformation.claimField(name, annotation);
        }
    }
}

