/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.Field;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.ValidationException;
import org.apache.tapestry.Validator;
import org.apache.tapestry.ioc.MessageFormatter;

public class FieldValidatorImpl
implements FieldValidator {
    private final Field _field;
    private final Object _constraintValue;
    private final MessageFormatter _messageFormatter;
    private final Validator _validator;

    public FieldValidatorImpl(Field field, Object constraintValue, MessageFormatter messageFormatter, Validator validator) {
        this._field = field;
        this._constraintValue = constraintValue;
        this._messageFormatter = messageFormatter;
        this._validator = validator;
    }

    public void validate(Object value) throws ValidationException {
        if (!this._validator.invokeIfBlank() && this.isBlank(value)) {
            return;
        }
        if (value != null && !this._validator.getValueType().isInstance(value)) {
            return;
        }
        this._validator.validate(this._field, this._constraintValue, this._messageFormatter, value);
    }

    private boolean isBlank(Object value) {
        return value == null || value.equals("");
    }
}

