/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Field;
import org.apache.tapestry.FieldValidator;
import org.apache.tapestry.Validator;
import org.apache.tapestry.internal.services.CompositeFieldValidator;
import org.apache.tapestry.internal.services.FieldValidatorImpl;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.services.ValidatorSpecification;
import org.apache.tapestry.ioc.MessageFormatter;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.FieldValidatorSource;
import org.apache.tapestry.services.ValidationMessagesSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldValidatorSourceImpl
implements FieldValidatorSource {
    private final ValidationMessagesSource _messagesSource;
    private final Map<String, Validator> _validators;
    private final TypeCoercer _typeCoercer;

    public FieldValidatorSourceImpl(ValidationMessagesSource messagesSource, TypeCoercer typeCoercer, Map<String, Validator> validators) {
        this._messagesSource = messagesSource;
        this._typeCoercer = typeCoercer;
        this._validators = validators;
    }

    @Override
    public FieldValidator createValidator(Field field, String validatorType, String constraintValue) {
        Component component = (Component)Defense.cast((Object)field, Component.class, (String)"field");
        Defense.notBlank((String)validatorType, (String)"validatorType");
        ComponentResources componentResources = component.getComponentResources();
        String overrideId = componentResources.getId();
        Locale locale = componentResources.getLocale();
        Messages overrideMessages = componentResources.getContainerMessages();
        return this.createValidator(field, validatorType, constraintValue, overrideId, overrideMessages, locale);
    }

    @Override
    public FieldValidator createValidator(Field field, String validatorType, String constraintValue, String overrideId, Messages overrideMessages, Locale locale) {
        Defense.notBlank((String)validatorType, (String)"validatorType");
        Validator validator = this._validators.get(validatorType);
        if (validator == null) {
            throw new IllegalArgumentException(ServicesMessages.unknownValidatorType(validatorType, InternalUtils.sortedKeys(this._validators)));
        }
        Object coercedConstraintValue = this.coerceConstraintValue(constraintValue, validator.getConstraintType());
        MessageFormatter formatter = this.findMessageFormatter(overrideId, overrideMessages, locale, validatorType, validator);
        return new FieldValidatorImpl(field, coercedConstraintValue, formatter, validator);
    }

    private MessageFormatter findMessageFormatter(String overrideId, Messages overrideMessages, Locale locale, String validatorType, Validator validator) {
        String overrideKey = overrideId + "-" + validatorType;
        if (overrideMessages.contains(overrideKey)) {
            return overrideMessages.getFormatter(overrideKey);
        }
        Messages messages = this._messagesSource.getValidationMessages(locale);
        String key = validator.getMessageKey();
        return messages.getFormatter(key);
    }

    @Override
    public FieldValidator createValidators(Field field, String specification) {
        List<ValidatorSpecification> specs = FieldValidatorSourceImpl.parse(specification);
        List fieldValidators = CollectionFactory.newList();
        for (ValidatorSpecification spec : specs) {
            fieldValidators.add(this.createValidator(field, spec.getValidatorType(), spec.getConstraintValue()));
        }
        if (fieldValidators.size() == 1) {
            return (FieldValidator)fieldValidators.get(0);
        }
        return new CompositeFieldValidator(fieldValidators);
    }

    private Object coerceConstraintValue(String constraintValue, Class constraintType) {
        if (constraintType == null) {
            return null;
        }
        return this._typeCoercer.coerce((Object)constraintValue, constraintType);
    }

    static List<ValidatorSpecification> parse(String specification) {
        List result = CollectionFactory.newList();
        char[] input = specification.toCharArray();
        int cursor = 0;
        int start = -1;
        String type = null;
        String value = null;
        boolean skipWhitespace = true;
        State state = State.TYPE_START;
        block14: while (cursor < input.length) {
            char ch = input[cursor];
            if (skipWhitespace && Character.isWhitespace(ch)) {
                ++cursor;
                continue;
            }
            skipWhitespace = false;
            switch (state) {
                case TYPE_START: {
                    if (Character.isLetter(ch)) {
                        start = cursor;
                        state = State.TYPE_END;
                        break;
                    }
                    FieldValidatorSourceImpl.parseError(cursor, specification);
                }
                case TYPE_END: {
                    if (Character.isLetter(ch)) break;
                    type = specification.substring(start, cursor);
                    skipWhitespace = true;
                    state = State.EQUALS_OR_COMMA;
                    continue block14;
                }
                case EQUALS_OR_COMMA: {
                    if (ch == '=') {
                        skipWhitespace = true;
                        state = State.VALUE_START;
                        break;
                    }
                    if (ch == ',') {
                        result.add(new ValidatorSpecification(type));
                        type = null;
                        state = State.COMMA;
                        continue block14;
                    }
                    FieldValidatorSourceImpl.parseError(cursor, specification);
                }
                case VALUE_START: {
                    start = cursor;
                    state = State.VALUE_END;
                    break;
                }
                case VALUE_END: {
                    if (!Character.isWhitespace(ch) && ch != ',') break;
                    value = specification.substring(start, cursor);
                    result.add(new ValidatorSpecification(type, value));
                    type = null;
                    value = null;
                    skipWhitespace = true;
                    state = State.COMMA;
                    continue block14;
                }
                case COMMA: {
                    if (ch == ',') {
                        skipWhitespace = true;
                        state = State.TYPE_START;
                        break;
                    }
                    FieldValidatorSourceImpl.parseError(cursor, specification);
                }
            }
            ++cursor;
        }
        switch (state) {
            case TYPE_END: {
                type = specification.substring(start);
            }
            case EQUALS_OR_COMMA: {
                result.add(new ValidatorSpecification(type));
                break;
            }
            case VALUE_START: {
                result.add(new ValidatorSpecification(type, ""));
                break;
            }
            case VALUE_END: {
                value = specification.substring(start);
                result.add(new ValidatorSpecification(type, value));
                break;
            }
        }
        return result;
    }

    private static void parseError(int cursor, String specification) {
        throw new RuntimeException(ServicesMessages.validatorSpecificationParseError(cursor, specification));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        TYPE_START,
        TYPE_END,
        EQUALS_OR_COMMA,
        VALUE_START,
        VALUE_END,
        COMMA;

    }
}

