/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.Asset;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.AssetSource;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.TransformConstants;

public class InjectAssetWorker
implements ComponentClassTransformWorker {
    static final String ASSET_TYPE_NAME = Asset.class.getName();
    private final AssetSource _assetSource;

    public InjectAssetWorker(AssetSource assetSource) {
        this._assetSource = assetSource;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> names = transformation.findFieldsOfType(ASSET_TYPE_NAME);
        String assetSourceFieldName = null;
        String baseResourceFieldName = null;
        String resourcesFieldName = null;
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        for (String name : names) {
            String path;
            Inject annotation = transformation.getFieldAnnotation(name, Inject.class);
            if (annotation == null || (path = annotation.value()).equals("")) continue;
            if (assetSourceFieldName == null) {
                assetSourceFieldName = transformation.addInjectedField(AssetSource.class, "assetSource", this._assetSource);
                baseResourceFieldName = transformation.addInjectedField(Resource.class, "baseResource", model.getBaseResource());
                resourcesFieldName = transformation.getResourcesFieldName();
            }
            builder.addln("%s = %s.findAsset(%s, \"%s\", %s.getLocale());", new Object[]{name, assetSourceFieldName, baseResourceFieldName, path, resourcesFieldName});
            transformation.makeReadOnly(name);
            transformation.claimField(name, annotation);
        }
        if (assetSourceFieldName == null) {
            return;
        }
        builder.end();
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, builder.toString());
    }
}

