/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.Block;
import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.TransformConstants;

public class InjectBlockWorker
implements ComponentClassTransformWorker {
    static final String BLOCK_TYPE_NAME = Block.class.getName();

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> fieldNames = transformation.findFieldsOfType(BLOCK_TYPE_NAME);
        if (fieldNames.isEmpty()) {
            return;
        }
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        int count = 0;
        String resourcesFieldName = transformation.getResourcesFieldName();
        for (String fieldName : fieldNames) {
            Inject annotation = transformation.getFieldAnnotation(fieldName, Inject.class);
            if (annotation == null) continue;
            String blockId = this.getBlockId(fieldName, annotation);
            builder.addln("%s = %s.getBlock(\"%s\");", new Object[]{fieldName, resourcesFieldName, blockId});
            transformation.makeReadOnly(fieldName);
            transformation.claimField(fieldName, annotation);
            ++count;
        }
        if (count == 0) {
            return;
        }
        builder.end();
        transformation.extendMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_SIGNATURE, builder.toString());
    }

    private String getBlockId(String fieldName, Inject annotation) {
        String annotationId = annotation.value();
        if (InternalUtils.isNonBlank((String)annotationId)) {
            return annotationId;
        }
        return InternalUtils.stripMemberPrefix((String)fieldName);
    }
}

