/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.annotations.Inject;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.ServiceLocator;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;

public class InjectNamedWorker
implements ComponentClassTransformWorker {
    private final ObjectProvider _objectProvider;
    private final ServiceLocator _locator;

    public InjectNamedWorker(ObjectProvider objectProvider, ServiceLocator locator) {
        this._objectProvider = objectProvider;
        this._locator = locator;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        for (String fieldName : transformation.findFieldsWithAnnotation(Inject.class)) {
            Inject annotation = transformation.getFieldAnnotation(fieldName, Inject.class);
            String value = annotation.value();
            if (InternalUtils.isBlank((String)value)) continue;
            this.injectNamed(fieldName, value, transformation, model);
            transformation.claimField(fieldName, annotation);
        }
    }

    private void injectNamed(String fieldName, String value, ClassTransformation transformation, MutableComponentModel model) {
        String fieldType = transformation.getFieldType(fieldName);
        Class type = transformation.toClass(fieldType);
        Object inject = this._objectProvider.provide(value, type, this._locator);
        transformation.injectField(fieldName, inject);
    }
}

