/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.annotations.InjectPage;
import org.apache.tapestry.internal.services.RequestPageCache;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.MethodSignature;

public class InjectPageWorker
implements ComponentClassTransformWorker {
    private final RequestPageCache _requestPageCache;

    public InjectPageWorker(RequestPageCache requestPageCache) {
        this._requestPageCache = requestPageCache;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        List<String> names = transformation.findFieldsWithAnnotation(InjectPage.class);
        if (names.isEmpty()) {
            return;
        }
        String cacheFieldName = transformation.addInjectedField(RequestPageCache.class, "_requestPageCache", this._requestPageCache);
        for (String name : names) {
            this.addInjectedPage(transformation, name, cacheFieldName);
        }
    }

    private void addInjectedPage(ClassTransformation transformation, String fieldName, String cacheFieldName) {
        InjectPage annotation = transformation.getFieldAnnotation(fieldName, InjectPage.class);
        String pageName = annotation.value();
        String fieldType = transformation.getFieldType(fieldName);
        String methodName = transformation.newMemberName("_read_inject_page_" + InternalUtils.stripMemberPrefix((String)fieldName));
        MethodSignature sig = new MethodSignature(2, fieldType, methodName, null, null);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.add("%s page = %s.", new Object[]{Page.class.getName(), cacheFieldName});
        if (InternalUtils.isBlank((String)pageName)) {
            builder.add("getByClassName(\"%s\")", new Object[]{fieldType});
        } else {
            builder.add("get(\"%s\")", new Object[]{pageName});
        }
        builder.addln(";", new Object[0]);
        builder.addln("return (%s) page.getRootElement().getComponent();", new Object[]{fieldType});
        builder.end();
        transformation.addMethod(sig, builder.toString());
        transformation.replaceReadAccess(fieldName, methodName);
        transformation.makeReadOnly(fieldName);
        transformation.removeField(fieldName);
        transformation.claimField(fieldName, annotation);
    }
}

