/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.apache.tapestry.Binding;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.events.InvalidationListener;
import org.apache.tapestry.internal.bindings.LiteralBinding;
import org.apache.tapestry.internal.bindings.PropBindingFactory;
import org.apache.tapestry.internal.services.CheckForUpdatesFilter;
import org.apache.tapestry.internal.services.ClasspathAssetFactory;
import org.apache.tapestry.internal.services.ComponentClassTransformer;
import org.apache.tapestry.internal.services.ComponentClassTransformerImpl;
import org.apache.tapestry.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry.internal.services.ComponentInstantiatorSourceImpl;
import org.apache.tapestry.internal.services.ComponentInvocationMap;
import org.apache.tapestry.internal.services.ComponentTemplateSource;
import org.apache.tapestry.internal.services.ComponentTemplateSourceImpl;
import org.apache.tapestry.internal.services.ContextAssetFactory;
import org.apache.tapestry.internal.services.ContextPathSource;
import org.apache.tapestry.internal.services.CookieSink;
import org.apache.tapestry.internal.services.CookieSource;
import org.apache.tapestry.internal.services.DefaultRequestExceptionHandler;
import org.apache.tapestry.internal.services.FormParameterLookup;
import org.apache.tapestry.internal.services.LinkFactory;
import org.apache.tapestry.internal.services.LinkFactoryImpl;
import org.apache.tapestry.internal.services.LocalizationFilter;
import org.apache.tapestry.internal.services.LocalizationSetter;
import org.apache.tapestry.internal.services.LocalizationSetterImpl;
import org.apache.tapestry.internal.services.NoOpComponentInvocationMap;
import org.apache.tapestry.internal.services.PageElementFactory;
import org.apache.tapestry.internal.services.PageElementFactoryImpl;
import org.apache.tapestry.internal.services.PageLoader;
import org.apache.tapestry.internal.services.PageLoaderImpl;
import org.apache.tapestry.internal.services.PageMarkupRenderer;
import org.apache.tapestry.internal.services.PageMarkupRendererImpl;
import org.apache.tapestry.internal.services.PagePool;
import org.apache.tapestry.internal.services.PagePoolImpl;
import org.apache.tapestry.internal.services.PageResponseRenderer;
import org.apache.tapestry.internal.services.PageResponseRendererImpl;
import org.apache.tapestry.internal.services.PageTemplateLocator;
import org.apache.tapestry.internal.services.PageTemplateLocatorImpl;
import org.apache.tapestry.internal.services.RequestPageCache;
import org.apache.tapestry.internal.services.RequestPageCacheImpl;
import org.apache.tapestry.internal.services.ResourceCache;
import org.apache.tapestry.internal.services.ResourceCacheImpl;
import org.apache.tapestry.internal.services.ResourceStreamer;
import org.apache.tapestry.internal.services.ResourceStreamerImpl;
import org.apache.tapestry.internal.services.SessionHolder;
import org.apache.tapestry.internal.services.TemplateParser;
import org.apache.tapestry.internal.services.TemplateParserImpl;
import org.apache.tapestry.internal.services.URLEncoder;
import org.apache.tapestry.internal.services.UpdateListenerHub;
import org.apache.tapestry.internal.services.UpdateListenerHubImpl;
import org.apache.tapestry.internal.util.IntegerRange;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.LogSource;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.annotations.Contribute;
import org.apache.tapestry.ioc.annotations.Id;
import org.apache.tapestry.ioc.annotations.Inject;
import org.apache.tapestry.ioc.annotations.InjectService;
import org.apache.tapestry.ioc.annotations.Lifecycle;
import org.apache.tapestry.ioc.annotations.Match;
import org.apache.tapestry.ioc.annotations.Order;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ChainBuilder;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.LoggingDecorator;
import org.apache.tapestry.ioc.services.PropertyAccess;
import org.apache.tapestry.ioc.services.ThreadCleanupHub;
import org.apache.tapestry.ioc.services.ThreadCleanupListener;
import org.apache.tapestry.ioc.services.ThreadLocale;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.services.ApplicationGlobals;
import org.apache.tapestry.services.ApplicationInitializer;
import org.apache.tapestry.services.ApplicationInitializerFilter;
import org.apache.tapestry.services.AssetFactory;
import org.apache.tapestry.services.BindingFactory;
import org.apache.tapestry.services.BindingSource;
import org.apache.tapestry.services.ClasspathAssetAliasManager;
import org.apache.tapestry.services.ComponentClassResolver;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.ComponentMessagesSource;
import org.apache.tapestry.services.Context;
import org.apache.tapestry.services.MarkupWriterFactory;
import org.apache.tapestry.services.PageRenderInitializer;
import org.apache.tapestry.services.PersistentFieldManager;
import org.apache.tapestry.services.PersistentLocale;
import org.apache.tapestry.services.Request;
import org.apache.tapestry.services.RequestExceptionHandler;
import org.apache.tapestry.services.RequestFilter;
import org.apache.tapestry.services.RequestGlobals;
import org.apache.tapestry.services.ResourceDigestGenerator;
import org.apache.tapestry.services.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Id(value="tapestry.internal")
public final class InternalModule {
    private final ComponentInstantiatorSource _componentInstantiatorSource;
    private final ComponentTemplateSource _componentTemplateSource;
    private final UpdateListenerHub _updateListenerHub;
    private final ThreadCleanupHub _threadCleanupHub;
    private final ComponentClassResolver _componentClassResolver;
    private final ChainBuilder _chainBuilder;
    private final Request _request;
    private final Response _response;
    private final ThreadLocale _threadLocale;
    private final RequestGlobals _requestGlobals;
    private final RequestPageCache _pageCache;

    public InternalModule(@InjectService(value="ComponentInstantiatorSource") ComponentInstantiatorSource componentInstantiatorSource, @InjectService(value="UpdateListenerHub") UpdateListenerHub updateListenerHub, @InjectService(value="tapestry.ioc.ThreadCleanupHub") ThreadCleanupHub threadCleanupHub, @InjectService(value="ComponentTemplateSource") ComponentTemplateSource componentTemplateSource, @InjectService(value="tapestry.ComponentClassResolver") ComponentClassResolver componentClassResolver, @InjectService(value="tapestry.ioc.ChainBuilder") ChainBuilder chainBuilder, @Inject(value="infrastructure:Request") Request request, @Inject(value="infrastructure:Response") Response response, @InjectService(value="tapestry.ioc.ThreadLocale") ThreadLocale threadLocale, @Inject(value="infrastructure:RequestGlobals") RequestGlobals requestGlobals, @InjectService(value="RequestPageCache") RequestPageCache pageCache) {
        this._componentInstantiatorSource = componentInstantiatorSource;
        this._updateListenerHub = updateListenerHub;
        this._threadCleanupHub = threadCleanupHub;
        this._componentTemplateSource = componentTemplateSource;
        this._componentClassResolver = componentClassResolver;
        this._chainBuilder = chainBuilder;
        this._request = request;
        this._response = response;
        this._threadLocale = threadLocale;
        this._requestGlobals = requestGlobals;
        this._pageCache = pageCache;
    }

    public ComponentClassTransformer buildComponentClassTransformer(@InjectService(value="tapestry.ComponentClassTransformWorker") ComponentClassTransformWorker workerChain, @InjectService(value="tapestry.ioc.LogSource") LogSource logSource) {
        ComponentClassTransformerImpl transformer = new ComponentClassTransformerImpl(workerChain, logSource);
        this._componentInstantiatorSource.addInvalidationListener(transformer);
        return transformer;
    }

    public ComponentInstantiatorSource buildComponentInstantiatorSource(@InjectService(value="tapestry.ioc.ClassFactory") ClassFactory classFactory, @InjectService(value="ComponentClassTransformer") ComponentClassTransformer transformer, Log log) {
        ComponentInstantiatorSourceImpl source = new ComponentInstantiatorSourceImpl(classFactory.getClassLoader(), transformer, log);
        this._updateListenerHub.addUpdateListener(source);
        return source;
    }

    public ComponentTemplateSource buildComponentTemplateSource(@InjectService(value="TemplateParser") TemplateParser parser, @InjectService(value="PageTemplateLocator") PageTemplateLocator locator) {
        ComponentTemplateSourceImpl service = new ComponentTemplateSourceImpl(parser, locator);
        this._updateListenerHub.addUpdateListener(service);
        return service;
    }

    @Lifecycle(value="perthread")
    public static TemplateParser buildTemplateParser(Log log) {
        return new TemplateParserImpl(log);
    }

    public PageElementFactory buildPageElementFactory(@Inject(value="infrastructure:TypeCoercer") TypeCoercer typeCoercer, @Inject(value="infrastructure:BindingSource") BindingSource bindingSource, @Inject(value="infrastructure:ComponentMessagesSource") ComponentMessagesSource componentMessagesSource) {
        return new PageElementFactoryImpl(this._componentInstantiatorSource, this._componentClassResolver, typeCoercer, bindingSource, componentMessagesSource);
    }

    public PageLoader buildPageLoader(@InjectService(value="PageElementFactory") PageElementFactory pageElementFactory, @InjectService(value="tapestry.BindingSource") BindingSource bindingSource, @InjectService(value="LinkFactory") LinkFactory linkFactory, @Inject(value="infrastructure:PersistentFieldManager") PersistentFieldManager persistentFieldManager) {
        PageLoaderImpl service = new PageLoaderImpl(this._componentTemplateSource, pageElementFactory, bindingSource, linkFactory, persistentFieldManager);
        this._componentInstantiatorSource.addInvalidationListener(service);
        return service;
    }

    public PagePool buildPagePool(Log log, @InjectService(value="PageLoader") PageLoader pageLoader, @Inject(value="infrastructure:ComponentMessagesSource") ComponentMessagesSource componentMessagesSource) {
        PagePoolImpl service = new PagePoolImpl(log, pageLoader, this._threadLocale);
        pageLoader.addInvalidationListener(service);
        componentMessagesSource.addInvalidationListener(service);
        this._componentTemplateSource.addInvalidationListener(service);
        return service;
    }

    public static UpdateListenerHub buildUpdateListenerHub() {
        return new UpdateListenerHubImpl();
    }

    @Match(value={"tapestry.*", "tapestry.*.*"})
    @Order(value={"before:*.*"})
    public static <T> T decorateWithLogging(Class<T> serviceInterface, T delegate, String serviceId, Log log, @InjectService(value="tapestry.ioc.LoggingDecorator") LoggingDecorator loggingDecorator) {
        return (T)loggingDecorator.build(serviceInterface, delegate, serviceId, log);
    }

    @Lifecycle(value="perthread")
    public RequestPageCache buildRequestPageCache(@InjectService(value="PagePool") PagePool pagePool) {
        RequestPageCacheImpl service = new RequestPageCacheImpl(this._componentClassResolver, pagePool);
        this._threadCleanupHub.addThreadCleanupListener((ThreadCleanupListener)service);
        return service;
    }

    public static PageResponseRenderer buildPageResponseRenderer(@InjectService(value="PageMarkupRenderer") PageMarkupRenderer markupRenderer, @InjectService(value="tapestry.MarkupWriterFactory") MarkupWriterFactory markupWriterFactory) {
        return new PageResponseRendererImpl(markupWriterFactory, markupRenderer);
    }

    public static PageMarkupRenderer buildPageMarkupRenderer(@InjectService(value="tapestry.PageRenderInitializer") PageRenderInitializer pageRenderInitializer) {
        return new PageMarkupRendererImpl(pageRenderInitializer);
    }

    @Contribute(value="tapestry.RequestHandler")
    public void contributeRequestFilters(OrderedConfiguration<RequestFilter> configuration, @InjectService(value="tapestry.RequestGlobals") RequestGlobals requestGlobals, @Inject(value="${tapestry.file-check-interval}") long checkInterval, @InjectService(value="LocalizationSetter") LocalizationSetter localizationSetter) {
        configuration.add("CheckForUpdates", (Object)new CheckForUpdatesFilter(this._updateListenerHub, checkInterval), new String[]{"before:*.*"});
        configuration.add("Localization", (Object)new LocalizationFilter(localizationSetter), new String[0]);
    }

    public LocalizationSetter buildLocalizationSetter(@InjectService(value="tapestry.PersistentLocale") PersistentLocale persistentLocale, @Inject(value="${tapestry.supported-locales}") String localeNames) {
        return new LocalizationSetterImpl(persistentLocale, this._threadLocale, localeNames);
    }

    @Contribute(value="tapestry.ioc.FactoryDefaults")
    public void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.file-check-interval", (Object)"1000");
        configuration.add((Object)"tapestry.supported-locales", (Object)"en");
        configuration.add((Object)"tapestry.default-cookie-max-age", (Object)"604800");
    }

    @Contribute(value="tapestry.ApplicationInitializer")
    public void contributeApplicationInitializerFilters(OrderedConfiguration<ApplicationInitializerFilter> configuration, final @InjectService(value="tapestry.ioc.PropertyAccess") PropertyAccess propertyAccess, final @Inject(value="infrastructure:TypeCoercer") TypeCoercer typeCoercer) {
        ApplicationInitializerFilter setApplicationPackage = new ApplicationInitializerFilter(){

            public void initializeApplication(Context context, ApplicationInitializer initializer) {
                String packageName = context.getInitParameter("tapestry.app-package");
                InternalModule.this._componentClassResolver.setApplicationPackage(packageName);
                initializer.initializeApplication(context);
            }
        };
        configuration.add("SetApplicationPackage", (Object)setApplicationPackage, new String[]{"before:*.*"});
        final InvalidationListener listener = new InvalidationListener(){

            public void objectWasInvalidated() {
                propertyAccess.clearCache();
                typeCoercer.clearCache();
            }
        };
        ApplicationInitializerFilter clearCaches = new ApplicationInitializerFilter(){

            public void initializeApplication(Context context, ApplicationInitializer initializer) {
                InternalModule.this._componentInstantiatorSource.addInvalidationListener(listener);
                initializer.initializeApplication(context);
            }
        };
        configuration.add("ClearCachesOnInvalidation", (Object)clearCaches, new String[0]);
    }

    public BindingFactory buildPropBindingFactory(List<BindingFactory> configuration, @InjectService(value="tapestry.ioc.PropertyAccess") PropertyAccess propertyAccess, @InjectService(value="tapestry.ComponentClassFactory") ClassFactory classFactory) {
        PropBindingFactory service = new PropBindingFactory(propertyAccess, classFactory);
        this._componentInstantiatorSource.addInvalidationListener(service);
        configuration.add(service);
        return (BindingFactory)this._chainBuilder.build(BindingFactory.class, configuration);
    }

    public void contributePropBindingFactory(OrderedConfiguration<BindingFactory> configuration) {
        BindingFactory keywordFactory = new BindingFactory(){
            private final Map<String, Object> _keywords = CollectionFactory.newMap();
            {
                this._keywords.put("true", Boolean.TRUE);
                this._keywords.put("false", Boolean.FALSE);
                this._keywords.put("null", null);
            }

            public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
                String key = expression.trim().toLowerCase();
                if (this._keywords.containsKey(key)) {
                    return new LiteralBinding(description, this._keywords.get(key), location);
                }
                return null;
            }
        };
        BindingFactory thisFactory = new BindingFactory(){

            public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
                if ("this".equalsIgnoreCase(expression.trim())) {
                    return new LiteralBinding(description, container.getComponent(), location);
                }
                return null;
            }
        };
        BindingFactory longFactory = new BindingFactory(){
            private final Pattern _pattern = Pattern.compile("^\\s*(-?\\d+)\\s*$");

            public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
                Matcher matcher = this._pattern.matcher(expression);
                if (matcher.matches()) {
                    String value = matcher.group(1);
                    return new LiteralBinding(description, new Long(value), location);
                }
                return null;
            }
        };
        BindingFactory intRangeFactory = new BindingFactory(){
            private final Pattern _pattern = Pattern.compile("^\\s*(-?\\d+)\\s*\\.\\.\\s*(-?\\d+)\\s*$");

            public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
                Matcher matcher = this._pattern.matcher(expression);
                if (matcher.matches()) {
                    int start = Integer.parseInt(matcher.group(1));
                    int finish = Integer.parseInt(matcher.group(2));
                    IntegerRange range = new IntegerRange(start, finish);
                    return new LiteralBinding(description, range, location);
                }
                return null;
            }
        };
        BindingFactory doubleFactory = new BindingFactory(){
            private final Pattern _pattern = Pattern.compile("^\\s*(\\-?((\\d+\\.)|(\\d*\\.\\d+)))\\s*$");

            public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
                Matcher matcher = this._pattern.matcher(expression);
                if (matcher.matches()) {
                    String value = matcher.group(1);
                    return new LiteralBinding(description, new Double(value), location);
                }
                return null;
            }
        };
        BindingFactory stringFactory = new BindingFactory(){
            private final Pattern _pattern = Pattern.compile("^\\s*'(.*)'\\s*$");

            public Binding newBinding(String description, ComponentResources container, ComponentResources component, String expression, Location location) {
                Matcher matcher = this._pattern.matcher(expression);
                if (matcher.matches()) {
                    String value = matcher.group(1);
                    return new LiteralBinding(description, value, location);
                }
                return null;
            }
        };
        configuration.add("Keyword", (Object)keywordFactory, new String[0]);
        configuration.add("This", (Object)thisFactory, new String[0]);
        configuration.add("Long", (Object)longFactory, new String[0]);
        configuration.add("IntRange", (Object)intRangeFactory, new String[0]);
        configuration.add("Double", (Object)doubleFactory, new String[0]);
        configuration.add("StringLiteral", (Object)stringFactory, new String[0]);
    }

    public RequestExceptionHandler buildDefaultRequestExceptionHandler(@InjectService(value="PageResponseRenderer") PageResponseRenderer renderer) {
        return new DefaultRequestExceptionHandler(this._pageCache, renderer, this._response);
    }

    public LinkFactory buildLinkFactory(@InjectService(value="ContextPathSource") ContextPathSource contextPathSource, @InjectService(value="URLEncoder") URLEncoder encoder, @InjectService(value="ComponentInvocationMap") ComponentInvocationMap componentInvocationMap) {
        return new LinkFactoryImpl(contextPathSource, encoder, this._componentClassResolver, componentInvocationMap, this._pageCache);
    }

    public ContextPathSource buildContextPathSource() {
        return this._request;
    }

    public URLEncoder buildURLEncoder() {
        return this._response;
    }

    public ResourceStreamer buildResourceStreamer() {
        return new ResourceStreamerImpl(this._response);
    }

    public AssetFactory buildContextAssetFactory(@Inject(value="infrastructure:ApplicationGlobals") ApplicationGlobals globals) {
        return new ContextAssetFactory(this._request, globals.getContext());
    }

    public AssetFactory buildClasspathAssetFactory(@InjectService(value="ResourceCache") ResourceCache resourceCache, @Inject(value="infrastructure:ClasspathAssetAliasManager") ClasspathAssetAliasManager aliasManager) {
        ClasspathAssetFactory factory = new ClasspathAssetFactory(resourceCache, aliasManager);
        resourceCache.addInvalidationListener(factory);
        return factory;
    }

    public ResourceCache buildResourceCache(@Inject(value="infrastructure:ResourceDigestGenerator") ResourceDigestGenerator digestGenerator) {
        ResourceCacheImpl service = new ResourceCacheImpl(digestGenerator);
        this._updateListenerHub.addUpdateListener(service);
        return service;
    }

    public static ComponentInvocationMap buildComponentInvocationMap() {
        return new NoOpComponentInvocationMap();
    }

    public FormParameterLookup buildFormParameterLookup() {
        return this._request;
    }

    public SessionHolder buildSessionHolder() {
        return this._request;
    }

    public PageTemplateLocator buildPageTemplateLocator(@InjectService(value="ContextAssetFactory") AssetFactory contextAssetFactory, @Inject(value="infrastructure:ComponentClassResolver") ComponentClassResolver componentClassResolver) {
        return new PageTemplateLocatorImpl(contextAssetFactory.getRootResource(), componentClassResolver);
    }

    public CookieSource buildCookieSource() {
        return new CookieSource(){

            public Cookie[] getCookies() {
                return InternalModule.this._requestGlobals.getHTTPServletRequest().getCookies();
            }
        };
    }

    public CookieSink buildCookieSink() {
        return new CookieSink(){

            public void addCookie(Cookie cookie) {
                InternalModule.this._requestGlobals.getHTTPServletResponse().addCookie(cookie);
            }
        };
    }
}

