/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ComponentEventHandler;
import org.apache.tapestry.Link;
import org.apache.tapestry.internal.services.ActionLinkTarget;
import org.apache.tapestry.internal.services.ComponentInvocation;
import org.apache.tapestry.internal.services.ComponentInvocationMap;
import org.apache.tapestry.internal.services.ContextPathSource;
import org.apache.tapestry.internal.services.LinkFactory;
import org.apache.tapestry.internal.services.LinkFactoryListener;
import org.apache.tapestry.internal.services.LinkImpl;
import org.apache.tapestry.internal.services.PageLinkTarget;
import org.apache.tapestry.internal.services.RequestPageCache;
import org.apache.tapestry.internal.services.URLEncoder;
import org.apache.tapestry.internal.structure.ComponentPageElement;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.util.StrategyRegistry;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.services.ComponentClassResolver;

public class LinkFactoryImpl
implements LinkFactory {
    private final ContextPathSource _contextPathSource;
    private final URLEncoder _encoder;
    private final ComponentClassResolver _componentClassResolver;
    private final ComponentInvocationMap _componentInvocationMap;
    private final RequestPageCache _pageCache;
    private final List<LinkFactoryListener> _listeners = CollectionFactory.newThreadSafeList();
    private final StrategyRegistry<PassivateContextHandler> _registry;

    public LinkFactoryImpl(ContextPathSource contextPathSource, URLEncoder encoder, ComponentClassResolver componentClassResolver, ComponentInvocationMap componentInvocationMap, RequestPageCache pageCache) {
        this._contextPathSource = contextPathSource;
        this._encoder = encoder;
        this._componentClassResolver = componentClassResolver;
        this._componentInvocationMap = componentInvocationMap;
        this._pageCache = pageCache;
        Map registrations = CollectionFactory.newMap();
        registrations.put(Object.class, new PassivateContextHandler(){

            public void handle(Object result, List context) {
                context.add(result);
            }
        });
        registrations.put(Object[].class, new PassivateContextHandler<Object[]>(){

            @Override
            public void handle(Object[] result, List context) {
                for (Object o : result) {
                    context.add(o);
                }
            }
        });
        registrations.put(Collection.class, new PassivateContextHandler<Collection>(){

            @Override
            public void handle(Collection result, List context) {
                context.addAll(result);
            }
        });
        this._registry = StrategyRegistry.newInstance(PassivateContextHandler.class, (Map)registrations);
    }

    public void addListener(LinkFactoryListener listener) {
        this._listeners.add(listener);
    }

    public Link createActionLink(ComponentPageElement component, String action, boolean forForm, Object ... context) {
        Defense.notBlank((String)action, (String)"action");
        String pageName = component.getContainingPage().getName();
        String logicalPageName = this._componentClassResolver.resolvePageClassNameToPageName(pageName);
        ActionLinkTarget target = new ActionLinkTarget(action, logicalPageName, component.getNestedId());
        ComponentInvocation invocation = new ComponentInvocation(target, context);
        LinkImpl link = new LinkImpl(this._encoder, this._contextPathSource.getContextPath(), invocation, forForm);
        this._componentInvocationMap.store(link, invocation);
        for (LinkFactoryListener listener : this._listeners) {
            listener.createdActionLink(link);
        }
        return link;
    }

    public Link createPageLink(Page page) {
        Defense.notNull((Object)page, (String)"page");
        String pageName = page.getName();
        String logicalPageName = this._componentClassResolver.resolvePageClassNameToPageName(pageName);
        final List context = CollectionFactory.newList();
        ComponentEventHandler handler = new ComponentEventHandler(){

            public boolean handleResult(Object result, Component component, String methodDescription) {
                PassivateContextHandler contextHandler = (PassivateContextHandler)LinkFactoryImpl.this._registry.getByInstance(result);
                contextHandler.handle(result, context);
                return true;
            }
        };
        ComponentPageElement rootElement = page.getRootElement();
        rootElement.triggerEvent("passivate", null, handler);
        PageLinkTarget target = new PageLinkTarget(logicalPageName);
        ComponentInvocation invocation = new ComponentInvocation(target, context.toArray());
        LinkImpl link = new LinkImpl(this._encoder, this._contextPathSource.getContextPath(), invocation, false);
        this._componentInvocationMap.store(link, invocation);
        for (LinkFactoryListener listener : this._listeners) {
            listener.createdPageLink(link);
        }
        return link;
    }

    public Link createPageLink(String pageName) {
        Page page = this._pageCache.get(pageName);
        return this.createPageLink(page);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PassivateContextHandler<T> {
        public void handle(T var1, List var2);
    }
}

