/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.PrintWriter;
import org.apache.tapestry.Link;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.dom.DefaultMarkupModel;
import org.apache.tapestry.dom.Document;
import org.apache.tapestry.dom.Element;
import org.apache.tapestry.dom.MarkupModel;
import org.apache.tapestry.dom.Text;
import org.apache.tapestry.internal.services.ComponentInvocationMap;
import org.apache.tapestry.internal.services.NoOpComponentInvocationMap;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

public class MarkupWriterImpl
implements MarkupWriter {
    private final Document _document;
    private Element _current;
    private Text _currentText;
    private final ComponentInvocationMap _invocationMap;

    public MarkupWriterImpl() {
        this(new DefaultMarkupModel(), new NoOpComponentInvocationMap());
    }

    public MarkupWriterImpl(MarkupModel model, ComponentInvocationMap invocationMap) {
        this._document = new Document(model);
        this._invocationMap = invocationMap;
    }

    public void toMarkup(PrintWriter writer) {
        this._document.toMarkup(writer);
    }

    public String toString() {
        return this._document.toString();
    }

    public Document getDocument() {
        return this._document;
    }

    public Element getElement() {
        return this._current;
    }

    public void write(String text) {
        if (this._current == null && InternalUtils.isBlank((String)text)) {
            return;
        }
        this.ensureCurrentElement();
        if (text == null) {
            return;
        }
        if (this._currentText == null) {
            this._currentText = this._current.text(text);
            return;
        }
        this._currentText.write(text);
    }

    public void writef(String format, Object ... args) {
        this.write("");
        this._currentText.writef(format, args);
    }

    public void attributes(Object ... namesAndValues) {
        this.ensureCurrentElement();
        int i = 0;
        while (i < namesAndValues.length) {
            Object value;
            String name = namesAndValues[i++].toString();
            if ((value = namesAndValues[i++]) == null) continue;
            if (value instanceof Link) {
                this._invocationMap.store(this._current, (Link)value);
            }
            this._current.attribute(name, value.toString());
        }
    }

    private void ensureCurrentElement() {
        if (this._current == null) {
            throw new IllegalStateException(ServicesMessages.markupWriterNoCurrentElement());
        }
    }

    public Element element(String name, Object ... namesAndValues) {
        this._current = this._current == null ? this._document.newRootElement(name) : this._current.element(name, new String[0]);
        this.attributes(namesAndValues);
        this._currentText = null;
        return this._current;
    }

    public Element end() {
        this.ensureCurrentElement();
        this._current = this._current.getParent();
        this._currentText = null;
        return this._current;
    }

    public void comment(String text) {
        this.ensureCurrentElement();
        this._current.comment(text);
        this._currentText = null;
    }
}

