/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.tapestry.internal.TapestryUtils;
import org.apache.tapestry.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry.internal.services.MapMessages;
import org.apache.tapestry.internal.services.MessagesBundle;
import org.apache.tapestry.internal.services.MessagesSource;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.util.MultiKey;
import org.apache.tapestry.internal.util.URLChangeTracker;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.LocalizedNameGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesSourceImpl
extends InvalidationEventHubImpl
implements MessagesSource {
    private final URLChangeTracker _tracker;
    private final Map<MultiKey, Messages> _messagesByBundleIdAndLocale = CollectionFactory.newThreadSafeMap();
    private final Map<MultiKey, Map<String, String>> _cookedProperties = CollectionFactory.newThreadSafeMap();
    private final Map<Resource, Map<String, String>> _rawProperties = CollectionFactory.newThreadSafeMap();
    private final Map<String, String> _emptyMap = Collections.emptyMap();

    public MessagesSourceImpl(URLChangeTracker tracker) {
        this._tracker = tracker;
    }

    @Override
    public void checkForUpdates() {
        if (this._tracker.containsChanges()) {
            this._messagesByBundleIdAndLocale.clear();
            this._cookedProperties.clear();
            this._rawProperties.clear();
            this._tracker.clear();
            this.fireInvalidationEvent();
        }
    }

    @Override
    public Messages getMessages(MessagesBundle bundle, Locale locale) {
        MultiKey key = new MultiKey(bundle.getId(), locale);
        Messages result = this._messagesByBundleIdAndLocale.get(key);
        if (result == null) {
            result = this.buildMessages(bundle, locale);
            this._messagesByBundleIdAndLocale.put(key, result);
        }
        return result;
    }

    private Messages buildMessages(MessagesBundle bundle, Locale locale) {
        Map<String, String> properties = this.findBundleProperties(bundle, locale);
        return new MapMessages(properties);
    }

    private Map<String, String> findBundleProperties(MessagesBundle bundle, Locale locale) {
        if (bundle == null) {
            return this._emptyMap;
        }
        MultiKey key = new MultiKey(bundle.getId(), locale);
        Map<String, String> existing = this._cookedProperties.get(key);
        if (existing != null) {
            return existing;
        }
        Resource propertiesResource = bundle.getBaseResource().withExtension("properties");
        List localizations = CollectionFactory.newList();
        for (String localizedFile : new LocalizedNameGenerator(propertiesResource.getFile(), locale)) {
            Resource localized = propertiesResource.forFile(localizedFile);
            localizations.add(localized);
        }
        Collections.reverse(localizations);
        Map<String, String> previous = this.findBundleProperties(bundle.getParent(), locale);
        for (Resource localization : localizations) {
            Map<String, String> rawProperties = this.getRawProperties(localization);
            Map<String, String> properties = this.extend(previous, rawProperties);
            previous = properties;
        }
        this._cookedProperties.put(key, previous);
        return previous;
    }

    private Map<String, String> extend(Map<String, String> base, Map<String, String> rawProperties) {
        if (rawProperties.isEmpty()) {
            return base;
        }
        Map result = CollectionFactory.newMap(base);
        result.putAll(rawProperties);
        return result;
    }

    private Map<String, String> getRawProperties(Resource localization) {
        Map<String, String> result = this._rawProperties.get(localization);
        if (result == null) {
            result = this.readProperties(localization);
            this._rawProperties.put(localization, result);
        }
        return result;
    }

    private Map<String, String> readProperties(Resource resource) {
        URL url = resource.toURL();
        if (url == null) {
            return this._emptyMap;
        }
        this._tracker.add(url);
        Map result = CollectionFactory.newMap();
        Properties p = new Properties();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(url.openStream());
            p.load(is);
            ((InputStream)is).close();
            is = null;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ServicesMessages.failureReadingMessages(url, ex), ex);
            }
            catch (Throwable throwable) {
                TapestryUtils.close(is);
                throw throwable;
            }
        }
        TapestryUtils.close(is);
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = e.getKey().toString();
            String value = p.getProperty(key);
            result.put(key, value);
        }
        return result;
    }
}

