/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import org.apache.tapestry.annotations.OnEvent;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.apache.tapestry.model.MutableComponentModel;
import org.apache.tapestry.services.ClassTransformation;
import org.apache.tapestry.services.ComponentClassTransformWorker;
import org.apache.tapestry.services.MethodFilter;
import org.apache.tapestry.services.MethodSignature;
import org.apache.tapestry.services.TransformConstants;
import org.apache.tapestry.services.TransformUtils;

public class OnEventWorker
implements ComponentClassTransformWorker {
    static final String OBJECT_ARRAY_TYPE = "java.lang.Object[]";
    private final String[] _empty = new String[0];

    public void transform(final ClassTransformation transformation, MutableComponentModel model) {
        MethodFilter filter = new MethodFilter(){

            public boolean accept(MethodSignature signature) {
                return signature.getMethodName().startsWith("on") || transformation.getMethodAnnotation(signature, OnEvent.class) != null;
            }
        };
        List<MethodSignature> methods = transformation.findMethods(filter);
        if (methods.isEmpty()) {
            return;
        }
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if ($1.isAborted()) return $_;", new Object[0]);
        for (MethodSignature method : methods) {
            this.addCodeForMethod(builder, method, transformation);
        }
        builder.end();
        transformation.extendMethod(TransformConstants.HANDLE_COMPONENT_EVENT, builder.toString());
    }

    private void addCodeForMethod(BodyBuilder builder, MethodSignature method, ClassTransformation transformation) {
        boolean isNonVoid;
        String[] componentIds;
        int closeCount = 0;
        OnEvent annotation = transformation.getMethodAnnotation(method, OnEvent.class);
        String[] eventTypes = this.extractEventTypes(method, annotation);
        if (eventTypes.length > 0) {
            String fieldName = transformation.addInjectedField(String[].class, "eventTypes", eventTypes);
            builder.addln("if ($1.matchesByEventType(%s))", new Object[]{fieldName});
            builder.begin();
            ++closeCount;
        }
        if ((componentIds = this.extractComponentIds(method, annotation)).length > 0) {
            String fieldName = transformation.addInjectedField(String[].class, "componentIds", componentIds);
            builder.addln("if ($1.matchesByComponentId(%s, %s))", new Object[]{transformation.getResourcesFieldName(), fieldName});
            builder.begin();
            ++closeCount;
        }
        builder.addln("$_ = true;", new Object[0]);
        builder.addln("$1.setSource(this, \"%s.%s\");", new Object[]{transformation.getClassName(), method.getMediumDescription()});
        boolean bl = isNonVoid = !method.getReturnType().equals("void");
        if (isNonVoid) {
            builder.add("if ($1.storeResult(($w) ", new Object[0]);
        }
        builder.add("%s(", new Object[]{method.getMethodName()});
        this.buildMethodParameters(builder, method);
        if (isNonVoid) {
            builder.addln("))) return true;", new Object[0]);
        } else {
            builder.addln(");", new Object[0]);
        }
        for (int i = 0; i < closeCount; ++i) {
            builder.end();
        }
    }

    private String[] extractComponentIds(MethodSignature method, OnEvent annotation) {
        if (annotation != null) {
            return annotation.component();
        }
        String name = method.getMethodName();
        int fromx = name.indexOf("From");
        if (fromx < 0) {
            return this._empty;
        }
        String componentId = name.substring(fromx + 4);
        return new String[]{componentId};
    }

    private String[] extractEventTypes(MethodSignature method, OnEvent annotation) {
        String eventName;
        if (annotation != null) {
            return annotation.value();
        }
        String name = method.getMethodName();
        int fromx = name.indexOf("From");
        String string = eventName = fromx == -1 ? name.substring(2) : name.substring(2, fromx);
        if (eventName.equals("AnyEvent")) {
            return this._empty;
        }
        return new String[]{eventName};
    }

    private void buildMethodParameters(BodyBuilder builder, MethodSignature method) {
        int contextIndex = 0;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String type;
            if (i > 0) {
                builder.add(", ", new Object[0]);
            }
            if ((type = method.getParameterTypes()[i]).equals(OBJECT_ARRAY_TYPE)) {
                builder.add("$1.getContext()", new Object[0]);
                continue;
            }
            boolean isPrimitive = TransformUtils.isPrimitive(type);
            String wrapperType = TransformUtils.getWrapperTypeName(type);
            if (isPrimitive) {
                builder.add("(", new Object[0]);
            }
            builder.add("(%s)", new Object[]{wrapperType});
            builder.add("$1.coerceContext(%d, \"%s\")", new Object[]{contextIndex++, wrapperType});
            if (!isPrimitive) continue;
            builder.add(").%s()", new Object[]{TransformUtils.getUnwrapperMethodName(type)});
        }
    }
}

