/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.tapestry.Binding;
import org.apache.tapestry.internal.InternalComponentResources;
import org.apache.tapestry.internal.bindings.LiteralBinding;
import org.apache.tapestry.internal.parser.AttributeToken;
import org.apache.tapestry.internal.parser.BlockToken;
import org.apache.tapestry.internal.parser.BodyToken;
import org.apache.tapestry.internal.parser.CommentToken;
import org.apache.tapestry.internal.parser.ComponentTemplate;
import org.apache.tapestry.internal.parser.EndElementToken;
import org.apache.tapestry.internal.parser.ExpansionToken;
import org.apache.tapestry.internal.parser.ParameterToken;
import org.apache.tapestry.internal.parser.StartComponentToken;
import org.apache.tapestry.internal.parser.StartElementToken;
import org.apache.tapestry.internal.parser.TemplateToken;
import org.apache.tapestry.internal.parser.TextToken;
import org.apache.tapestry.internal.services.ComponentTemplateSource;
import org.apache.tapestry.internal.services.LinkFactory;
import org.apache.tapestry.internal.services.PageElementFactory;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.internal.structure.BlockImpl;
import org.apache.tapestry.internal.structure.BodyPageElement;
import org.apache.tapestry.internal.structure.ComponentPageElement;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.internal.structure.PageElement;
import org.apache.tapestry.internal.structure.PageImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.IdAllocator;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.internal.util.TapestryException;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.model.EmbeddedComponentModel;
import org.apache.tapestry.services.BindingSource;
import org.apache.tapestry.services.PersistentFieldManager;

class PageLoaderProcessor {
    private static Runnable NO_OP = new Runnable(){

        public void run() {
        }
    };
    private LinkedList<ComponentPageElement> _activeElementStack = CollectionFactory.newLinkedList();
    private boolean _addAttributesAsComponentBindings = false;
    private final BindingSource _bindingSource;
    private final LinkedList<BodyPageElement> _bodyPageElementStack = CollectionFactory.newLinkedList();
    private final LinkedList<ComponentPageElement> _componentQueue = CollectionFactory.newLinkedList();
    private final LinkedList<Boolean> _discardEndTagStack = CollectionFactory.newLinkedList();
    private final LinkedList<Runnable> _endElementCommandStack = CollectionFactory.newLinkedList();
    private final IdAllocator _idAllocator = new IdAllocator();
    private final LinkFactory _linkFactory;
    private ComponentModel _loadingComponentModel;
    private ComponentPageElement _loadingElement;
    private Locale _locale;
    private final OneShotLock _lock = new OneShotLock();
    private Page _page;
    private final PageElementFactory _pageElementFactory;
    private final PersistentFieldManager _persistentFieldManager;
    private final ComponentTemplateSource _templateSource;

    public PageLoaderProcessor(ComponentTemplateSource templateSource, PageElementFactory pageElementFactory, BindingSource bindingSource, LinkFactory linkFactory, PersistentFieldManager persistentFieldManager) {
        this._templateSource = templateSource;
        this._pageElementFactory = pageElementFactory;
        this._bindingSource = bindingSource;
        this._linkFactory = linkFactory;
        this._persistentFieldManager = persistentFieldManager;
    }

    private void bindParameterFromTemplate(ComponentPageElement component, AttributeToken token) {
        String name = token.getName();
        InternalComponentResources resources = component.getComponentResources();
        if (resources.isBound(name)) {
            return;
        }
        String defaultBindingPrefix = this.determineDefaultBindingPrefix(component, name, "literal");
        Binding binding = this._bindingSource.newBinding("parameter " + name, this._loadingElement.getComponentResources(), component.getComponentResources(), defaultBindingPrefix, token.getValue(), token.getLocation());
        component.bindParameter(name, binding);
    }

    private void addMixinsToComponent(ComponentPageElement component, EmbeddedComponentModel model, String mixins) {
        if (model != null) {
            for (String mixinClassName : model.getMixinClassNames()) {
                this._pageElementFactory.addMixinByClassName(component, mixinClassName);
            }
        }
        if (mixins != null) {
            for (String type : mixins.split(",")) {
                this._pageElementFactory.addMixinByTypeName(component, type);
            }
        }
    }

    private void bindParametersFromModel(EmbeddedComponentModel model, ComponentPageElement loadingComponent, ComponentPageElement component) {
        for (String name : model.getParameterNames()) {
            String value = model.getParameterValue(name);
            String defaultBindingPrefix = this.determineDefaultBindingPrefix(component, name, "prop");
            Binding binding = this._bindingSource.newBinding("parameter " + name, loadingComponent.getComponentResources(), component.getComponentResources(), defaultBindingPrefix, value, null);
            component.bindParameter(name, binding);
        }
    }

    private String determineDefaultBindingPrefix(ComponentPageElement component, String parameterName, String informalParameterBindingPrefix) {
        String defaultBindingPrefix = component.getDefaultBindingPrefix(parameterName);
        return defaultBindingPrefix != null ? defaultBindingPrefix : informalParameterBindingPrefix;
    }

    private void addRenderBodyElement() {
        PageElement element = this._pageElementFactory.newRenderBodyElement(this._loadingElement);
        this._loadingElement.addToTemplate(element);
    }

    private void addToBody(PageElement element) {
        this._bodyPageElementStack.peek().addToBody(element);
    }

    private void attribute(AttributeToken token) {
        if (this._addAttributesAsComponentBindings) {
            ComponentPageElement activeElement = this._activeElementStack.peek();
            this.bindParameterFromTemplate(activeElement, token);
            return;
        }
        PageElement element = this._pageElementFactory.newAttributeElement(token);
        this.addToBody(element);
    }

    private void body(BodyToken token) {
        this.addRenderBodyElement();
    }

    private void comment(CommentToken token) {
        PageElement commentElement = this._pageElementFactory.newCommentElement(token);
        this.addToBody(commentElement);
    }

    private void endElement(EndElementToken token) {
        boolean discard = this._discardEndTagStack.removeFirst();
        if (!discard) {
            PageElement element = this._pageElementFactory.newEndElement();
            this.addToBody(element);
        }
        Runnable runnable = this._endElementCommandStack.removeFirst();
        runnable.run();
    }

    private void expansion(ExpansionToken token) {
        PageElement element = this._pageElementFactory.newExpansionElement(this._loadingElement.getComponentResources(), token);
        this.addToBody(element);
    }

    private String generateEmbeddedId(String embeddedType, IdAllocator idAllocator) {
        int slashx = embeddedType.lastIndexOf("/");
        String baseId = embeddedType.substring(slashx + 1).toLowerCase();
        return idAllocator.allocateId(baseId);
    }

    public Page loadPage(String pageClassName, Locale locale) {
        this._lock.lock();
        this._locale = locale;
        this._page = new PageImpl(pageClassName, this._locale, this._linkFactory, this._persistentFieldManager);
        this.loadRootComponent(pageClassName);
        this.workComponentQueue();
        this._page.loaded();
        return this._page;
    }

    private void loadRootComponent(String className) {
        ComponentPageElement rootComponent = this._pageElementFactory.newRootComponentElement(this._page, className);
        this._page.setRootElement(rootComponent);
        this._componentQueue.addFirst(rootComponent);
    }

    private void loadTemplateForComponent(ComponentPageElement loadingElement) {
        this._loadingElement = loadingElement;
        this._loadingComponentModel = loadingElement.getComponentResources().getComponentModel();
        String componentClassName = this._loadingComponentModel.getComponentClassName();
        ComponentTemplate template = this._templateSource.getTemplate(this._loadingComponentModel, this._locale);
        if (template.isMissing()) {
            this.addRenderBodyElement();
            return;
        }
        Log log = this._loadingComponentModel.getLog();
        Set embeddedIds = CollectionFactory.newSet(this._loadingComponentModel.getEmbeddedComponentIds());
        this._idAllocator.clear();
        for (String id : template.getComponentIds()) {
            this._idAllocator.allocateId(id);
            embeddedIds.remove(id);
        }
        if (!embeddedIds.isEmpty()) {
            log.error((Object)ServicesMessages.embeddedComponentsNotInTemplate(embeddedIds, componentClassName));
        }
        this._addAttributesAsComponentBindings = false;
        BodyPageElement shunt = new BodyPageElement(){

            public void addToBody(PageElement element) {
                PageLoaderProcessor.this._loadingElement.addToTemplate(element);
            }
        };
        this._bodyPageElementStack.addFirst(shunt);
        block13: for (TemplateToken token : template.getTokens()) {
            switch (token.getTokenType()) {
                case TEXT: {
                    this.text((TextToken)token);
                    continue block13;
                }
                case EXPANSION: {
                    this.expansion((ExpansionToken)token);
                    continue block13;
                }
                case BODY: {
                    this.body((BodyToken)token);
                    continue block13;
                }
                case START_ELEMENT: {
                    this.startElement((StartElementToken)token);
                    continue block13;
                }
                case START_COMPONENT: {
                    this.startComponent((StartComponentToken)token);
                    continue block13;
                }
                case ATTRIBUTE: {
                    this.attribute((AttributeToken)token);
                    continue block13;
                }
                case END_ELEMENT: {
                    this.endElement((EndElementToken)token);
                    continue block13;
                }
                case COMMENT: {
                    this.comment((CommentToken)token);
                    continue block13;
                }
                case BLOCK: {
                    this.block((BlockToken)token);
                    continue block13;
                }
                case PARAMETER: {
                    this.parameter((ParameterToken)token);
                    continue block13;
                }
            }
            throw new IllegalStateException("Not implemented yet: " + (Object)((Object)token));
        }
        this._bodyPageElementStack.removeFirst();
    }

    private void parameter(ParameterToken token) {
        BlockImpl block = new BlockImpl(token.getLocation());
        String name = token.getName();
        LiteralBinding binding = new LiteralBinding("block parameter " + name, block, token.getLocation());
        this._activeElementStack.peek().bindParameter(name, binding);
        this.setupBlock(block);
    }

    private void setupBlock(BodyPageElement block) {
        this._bodyPageElementStack.addFirst(block);
        this._discardEndTagStack.addFirst(true);
        Runnable cleanup = new Runnable(){

            public void run() {
                PageLoaderProcessor.this._bodyPageElementStack.removeFirst();
            }
        };
        this._endElementCommandStack.add(cleanup);
    }

    private void block(BlockToken token) {
        BlockImpl block = new BlockImpl(token.getLocation());
        String id = token.getId();
        if (id != null) {
            this._loadingElement.addBlock(id, block);
        }
        this.setupBlock(block);
    }

    private void startComponent(StartComponentToken token) {
        EmbeddedComponentModel embeddedModel;
        String elementName = token.getElementName();
        String embeddedType = token.getType();
        String embeddedId = token.getId();
        String embeddedComponentClassName = null;
        if (embeddedId == null) {
            embeddedId = this.generateEmbeddedId(embeddedType, this._idAllocator);
        }
        if ((embeddedModel = this._loadingComponentModel.getEmbeddedComponentModel(embeddedId)) != null) {
            String modelType = embeddedModel.getComponentType();
            if (InternalUtils.isNonBlank((String)modelType) && embeddedType != null) {
                Log log = this._loadingComponentModel.getLog();
                log.error((Object)ServicesMessages.compTypeConflict(embeddedId, embeddedType, modelType));
            }
            embeddedType = modelType;
            embeddedComponentClassName = embeddedModel.getComponentClassName();
        }
        if (InternalUtils.isBlank((String)embeddedType) && InternalUtils.isBlank(embeddedComponentClassName)) {
            if (elementName != null) {
                embeddedType = "Any";
            } else {
                throw new TapestryException(ServicesMessages.noTypeForEmbeddedComponent(embeddedId, this._loadingComponentModel.getComponentClassName()), (Object)token, null);
            }
        }
        ComponentPageElement newComponent = this._pageElementFactory.newComponentElement(this._page, this._loadingElement, embeddedId, embeddedType, embeddedComponentClassName, elementName, token.getLocation());
        this.addMixinsToComponent(newComponent, embeddedModel, token.getMixins());
        if (embeddedModel != null) {
            this.bindParametersFromModel(embeddedModel, this._loadingElement, newComponent);
        }
        this.addToBody(newComponent);
        this._componentQueue.addFirst(newComponent);
        this._addAttributesAsComponentBindings = true;
        this._activeElementStack.addFirst(newComponent);
        this._bodyPageElementStack.addFirst(newComponent);
        this._discardEndTagStack.addFirst(true);
        Runnable cleanup = new Runnable(){

            public void run() {
                PageLoaderProcessor.this._activeElementStack.removeFirst();
                PageLoaderProcessor.this._bodyPageElementStack.removeFirst();
            }
        };
        this._endElementCommandStack.addFirst(cleanup);
    }

    private void startElement(StartElementToken token) {
        PageElement element = this._pageElementFactory.newStartElement(token);
        this.addToBody(element);
        this._addAttributesAsComponentBindings = false;
        this._discardEndTagStack.addFirst(false);
        this._endElementCommandStack.addFirst(NO_OP);
    }

    private void text(TextToken token) {
        PageElement element = this._pageElementFactory.newTextElement(token);
        this.addToBody(element);
    }

    private void workComponentQueue() {
        while (!this._componentQueue.isEmpty()) {
            ComponentPageElement componentElement = this._componentQueue.removeFirst();
            this.loadTemplateForComponent(componentElement);
        }
    }
}

