/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.io.IOException;
import org.apache.tapestry.internal.services.PageLinkHandler;
import org.apache.tapestry.internal.services.PageRenderer;
import org.apache.tapestry.internal.services.PageResponseRenderer;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.services.ComponentClassResolver;
import org.apache.tapestry.services.Dispatcher;
import org.apache.tapestry.services.Request;
import org.apache.tapestry.services.Response;

public class PageRenderDispatcher
implements Dispatcher {
    private final ComponentClassResolver _componentClassResolver;
    private final PageLinkHandler _handler;
    private final PageResponseRenderer _renderer;

    public PageRenderDispatcher(ComponentClassResolver componentClassResolver, PageLinkHandler handler, PageResponseRenderer renderer) {
        this._componentClassResolver = componentClassResolver;
        this._handler = handler;
        this._renderer = renderer;
    }

    public boolean dispatch(Request request, final Response response) throws IOException {
        String path = request.getPath();
        int searchStart = 1;
        while (true) {
            String pageName;
            int nextslashx;
            boolean atEnd = (nextslashx = path.indexOf(47, searchStart)) < 0;
            String string = pageName = atEnd ? path.substring(1) : path.substring(1, nextslashx);
            if (this._componentClassResolver.isPageName(pageName)) {
                Object[] context = atEnd ? new Object[]{} : path.substring(nextslashx + 1).split("/");
                PageRenderer renderer = new PageRenderer(){

                    public void renderPage(Page page) {
                        try {
                            PageRenderDispatcher.this._renderer.renderPageResponse(page, response);
                        }
                        catch (IOException ex) {
                            new RuntimeException(ex);
                        }
                    }
                };
                this._handler.handle(pageName, context, renderer);
                return true;
            }
            if (atEnd) {
                return false;
            }
            searchStart = nextslashx + 1;
        }
    }
}

