/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.List;
import java.util.Map;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.internal.services.PersistentFieldBundleImpl;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.services.PersistentFieldBundle;
import org.apache.tapestry.services.PersistentFieldManager;
import org.apache.tapestry.services.PersistentFieldStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentFieldManagerImpl
implements PersistentFieldManager {
    static final String META_KEY = "tapestry.persistence-strategy";
    static final String DEFAULT_STRATEGY = "session";
    private final Map<String, PersistentFieldStrategy> _strategies;

    public PersistentFieldManagerImpl(Map<String, PersistentFieldStrategy> strategies) {
        this._strategies = strategies;
    }

    private PersistentFieldStrategy getStrategy(String strategyName) {
        PersistentFieldStrategy result = this._strategies.get(strategyName);
        if (result == null) {
            String catalog = InternalUtils.joinSorted(this._strategies.keySet());
            throw new RuntimeException(ServicesMessages.unknownPersistentFieldStrategy(strategyName, catalog));
        }
        return result;
    }

    @Override
    public PersistentFieldBundle gatherChanges(String pageName) {
        List allChanges = CollectionFactory.newList();
        for (PersistentFieldStrategy strategy : this._strategies.values()) {
            allChanges.addAll(strategy.gatherFieldChanges(pageName));
        }
        return new PersistentFieldBundleImpl(allChanges);
    }

    @Override
    public void postChange(String pageName, ComponentResources resources, String fieldName, Object newValue) {
        String strategyName = this.findStrategy(resources, fieldName);
        PersistentFieldStrategy strategy = this.getStrategy(strategyName);
        strategy.postChange(pageName, resources.getNestedId(), fieldName, newValue);
    }

    private String findStrategy(ComponentResources resources, String fieldName) {
        ComponentModel model = resources.getComponentModel();
        String strategy = model.getFieldPersistenceStrategy(fieldName);
        if (InternalUtils.isNonBlank((String)strategy)) {
            return strategy;
        }
        for (ComponentResources search = resources; search != null; search = search.getContainerResources()) {
            model = search.getComponentModel();
            strategy = model.getMeta(META_KEY);
            if (strategy == null) continue;
            return strategy;
        }
        return DEFAULT_STRATEGY;
    }
}

