/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.lang.reflect.Constructor;
import org.apache.tapestry.internal.InternalComponentResources;
import org.apache.tapestry.internal.services.Instantiator;
import org.apache.tapestry.internal.services.ServicesMessages;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.runtime.Component;

public class ReflectiveInstantiator
implements Instantiator {
    private final ComponentModel _componentModel;
    private final Constructor _constructor;
    private final Object[] _constructorParameters;

    ReflectiveInstantiator(ComponentModel componentModel, Class instanceClass, Object[] constructorParameters) {
        this._componentModel = componentModel;
        this._constructorParameters = constructorParameters;
        this._constructor = ReflectiveInstantiator.findConstructor(instanceClass, constructorParameters.length);
    }

    public String toString() {
        return String.format("ReflectiveInstantiator[%s]", this._constructor);
    }

    static Constructor findConstructor(Class instanceClass, int parameterCount) {
        for (Constructor<?> c : instanceClass.getConstructors()) {
            if (c.getParameterTypes().length != parameterCount) continue;
            return c;
        }
        throw new RuntimeException(ServicesMessages.noConstructorFound(instanceClass));
    }

    public Component newInstance(InternalComponentResources resources) {
        Object[] parameters = (Object[])this._constructorParameters.clone();
        parameters[0] = resources;
        try {
            return (Component)this._constructor.newInstance(parameters);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ComponentModel getModel() {
        return this._componentModel;
    }
}

