/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.net.URL;
import java.util.Map;
import org.apache.tapestry.events.UpdateListener;
import org.apache.tapestry.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry.internal.services.ResourceCache;
import org.apache.tapestry.internal.util.URLChangeTracker;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.ResourceDigestGenerator;

public class ResourceCacheImpl
extends InvalidationEventHubImpl
implements ResourceCache,
UpdateListener {
    private final URLChangeTracker _tracker;
    private final ResourceDigestGenerator _digestGenerator;
    private final Map<Resource, Cached> _cache = CollectionFactory.newThreadSafeMap();
    static final long MISSING_RESOURCE_TIME_MODIFIED = -1L;

    public ResourceCacheImpl(ResourceDigestGenerator digestGenerator) {
        this(digestGenerator, new URLChangeTracker());
    }

    ResourceCacheImpl(ResourceDigestGenerator digestGenerator, URLChangeTracker tracker) {
        this._digestGenerator = digestGenerator;
        this._tracker = tracker;
    }

    public void checkForUpdates() {
        if (this._tracker.containsChanges()) {
            this._cache.clear();
            this._tracker.clear();
            this.fireInvalidationEvent();
        }
    }

    private Cached get(Resource resource) {
        Cached result = this._cache.get(resource);
        if (result == null) {
            result = new Cached(resource);
            this._cache.put(resource, result);
        }
        return result;
    }

    public String getDigest(Resource resource) {
        return this.get((Resource)resource)._digest;
    }

    public long getTimeModified(Resource resource) {
        return this.get((Resource)resource)._timeModified;
    }

    public boolean requiresDigest(Resource resource) {
        return this.get((Resource)resource)._requiresDigest;
    }

    private class Cached {
        final boolean _requiresDigest;
        final String _digest;
        final long _timeModified;

        Cached(Resource resource) {
            this._requiresDigest = ResourceCacheImpl.this._digestGenerator.requiresDigest(resource.getPath());
            URL url = resource.toURL();
            this._digest = this._requiresDigest && url != null ? ResourceCacheImpl.this._digestGenerator.generateDigest(url) : null;
            this._timeModified = url != null ? ResourceCacheImpl.this._tracker.add(url) : -1L;
        }
    }
}

