/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import javassist.CtClass;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.MessagesImpl;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.runtime.RenderCommand;
import org.apache.tapestry.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServicesMessages {
    private static final Messages MESSAGES = MessagesImpl.forClass(ServicesMessages.class);

    private ServicesMessages() {
    }

    static final String duplicateContribution(Object conflict, String name, Object existing) {
        return MESSAGES.format("duplicate-contribution", new Object[]{conflict, name, existing});
    }

    static final String infrastructureModeNotSet() {
        return MESSAGES.get("infrastructure-mode-not-set");
    }

    static final String infrastructurePropertyNotFound(String name, Collection<String> known) {
        String knownList = InternalUtils.joinSorted(known);
        return MESSAGES.format("infrastructure-property-not-found", new Object[]{name, knownList});
    }

    static final String infrastructurePropertyWrongType(String name, Object object, Class desiredType) {
        return MESSAGES.format("infrastructure-property-wrong-type", new Object[]{name, object, desiredType.getName()});
    }

    static final String markupWriterNoCurrentElement() {
        return MESSAGES.get("markup-writer-no-current-element");
    }

    static String noConstructorFound(Class instanceClass) {
        return MESSAGES.format("no-constructor-found", new Object[]{instanceClass.getName()});
    }

    static String missingDeclaredField(CtClass ctClass, String fieldName) {
        return MESSAGES.format("missing-declared-field", new Object[]{ctClass.getName(), fieldName});
    }

    static String errorAddingMethod(CtClass ctClass, String methodName, Throwable cause) {
        return MESSAGES.format("error-adding-method", new Object[]{ctClass.getName(), methodName, cause});
    }

    static String fieldAlreadyClaimed(String fieldName, CtClass ctClass, Object existingTag, Object newTag) {
        return MESSAGES.format("field-already-claimed", new Object[]{fieldName, ctClass.getName(), existingTag, newTag});
    }

    static String noDeclaredMethod(CtClass ctClass, MethodSignature methodSignature) {
        return MESSAGES.format("no-declared-method", new Object[]{ctClass.getName(), methodSignature});
    }

    static String incorrectClassForInstantiator(String className, Class componentClass) {
        return MESSAGES.format("incorrect-class-for-instantiator", new Object[]{className, componentClass.getName()});
    }

    static String classNotTransformed(String className) {
        return MESSAGES.format("class-not-transformed", new Object[]{className});
    }

    static String newParserError(Resource resource, Throwable cause) {
        return MESSAGES.format("new-parser-error", new Object[]{resource, cause});
    }

    static String missingTemplateResource(Resource resource) {
        return MESSAGES.format("missing-template-resource", new Object[]{resource});
    }

    static String templateParseError(Resource resource, Throwable cause) {
        return MESSAGES.format("template-parse-error", new Object[]{resource, cause});
    }

    static String contentInsideBodyNotAllowed(Location location) {
        return MESSAGES.format("content-inside-body-not-allowed", new Object[]{location});
    }

    static String mayNotNestElementsInsideBody(String elementName) {
        return MESSAGES.format("may-not-nest-elements-inside-body", new Object[]{elementName});
    }

    static String methodCompileError(MethodSignature signature, String methodBody, Throwable cause) {
        return MESSAGES.format("method-compile-error", new Object[]{signature, methodBody, cause});
    }

    static String renderQueueError(RenderCommand command, Throwable cause) {
        return MESSAGES.format("render-queue-error", new Object[]{command, cause});
    }

    static String readOnlyField(String className, String fieldName) {
        return MESSAGES.format("read-only-field", new Object[]{className, fieldName});
    }

    static String noInjectionFound(String className, String fieldName, String fieldType) {
        return MESSAGES.format("no-injection-found", new Object[]{className, fieldName, fieldType});
    }

    static String nonPrivateFields(String className, List<String> names) {
        return MESSAGES.format("non-private-fields", new Object[]{className, InternalUtils.joinSorted(names)});
    }

    static String compRequiresIdOrType() {
        return MESSAGES.get("comp-requires-id-or-type");
    }

    static String compTypeConflict(String embeddedId, String templateType, String modelType) {
        return MESSAGES.format("comp-type-conflict", new Object[]{embeddedId, templateType, modelType});
    }

    static String noTypeForEmbeddedComponent(String embeddedId, String componentClassName) {
        return MESSAGES.format("no-type-for-embedded-component", new Object[]{embeddedId, componentClassName});
    }

    static String embeddedComponentsNotInTemplate(Collection<String> ids, String componentClassName) {
        return MESSAGES.format("embedded-components-not-in-template", new Object[]{InternalUtils.joinSorted(ids), componentClassName});
    }

    static String bindingSourceFailure(String expression, Throwable cause) {
        return MESSAGES.format("binding-source-failure", new Object[]{expression, cause});
    }

    static String contextIndexOutOfRange(String methodDescription) {
        return MESSAGES.format("context-index-out-of-range", new Object[]{methodDescription});
    }

    static String pageDoesNotExist(String pageName) {
        return MESSAGES.format("page-does-not-exist", new Object[]{pageName});
    }

    static String pageNameUnresolved(String pageClassName) {
        return MESSAGES.format("page-name-unresolved", new Object[]{pageClassName});
    }

    static String exceptionInMethodParameter(String methodDescription, int index, Throwable cause) {
        return MESSAGES.format("exception-in-method-parameter", new Object[]{methodDescription, index + 1, cause});
    }

    static String componentEventIsAborted(String methodDescription) {
        return MESSAGES.format("component-event-is-aborted", new Object[]{methodDescription});
    }

    static String unknownPersistentFieldStrategy(String stategyName, String catalog) {
        return MESSAGES.format("unknown-persistent-field-strategy", new Object[]{stategyName, catalog});
    }

    static String couldNotResolvePageName(String pageName) {
        return MESSAGES.format("could-not-resolve-page-name", new Object[]{pageName});
    }

    static String couldNotResolveComponentType(String componentType) {
        return MESSAGES.format("could-not-resolve-component-type", new Object[]{componentType});
    }

    static String couldNotResolveMixinType(String mixinType) {
        return MESSAGES.format("could-not-resolve-mixin-type", new Object[]{mixinType});
    }

    static String parameterNameMustBeUnique(String parameterName, String parameterValue) {
        return MESSAGES.format("parameter-name-must-be-unique", new Object[]{parameterName, parameterValue});
    }

    static String pageIsDirty(Object page) {
        return MESSAGES.format("page-is-dirty", new Object[]{page});
    }

    static String componentInstanceIsNotAPage(String methodDescription, Component component, Component result) {
        return MESSAGES.format("component-instance-is-not-a-page", new Object[]{methodDescription, component.getComponentResources().getCompleteId(), result.getComponentResources().getCompleteId()});
    }

    static String failureReadingMessages(URL url, Throwable cause) {
        return MESSAGES.format("failure-reading-messages", new Object[]{url, cause});
    }

    static String unknownAssetPrefix(String path) {
        return MESSAGES.format("unknown-asset-prefix", new Object[]{path});
    }

    static String assetDoesNotExist(Resource resource) {
        return MESSAGES.format("asset-does-not-exist", new Object[]{resource});
    }

    static String wrongAssetDigest(Resource resource) {
        return MESSAGES.format("wrong-asset-digest", new Object[]{resource.getPath()});
    }

    static String componentNotAssignableToField(Component component, String fieldName, String fieldType) {
        return MESSAGES.format("component-not-assignable-to-field", new Object[]{component.getComponentResources().getCompleteId(), fieldName, fieldType});
    }

    static String unknownValidatorType(String validatorType, List<String> knownValidatorTypes) {
        return MESSAGES.format("unknown-validator-type", new Object[]{validatorType, InternalUtils.join(knownValidatorTypes)});
    }

    static String unknownTranslatorType(String translatorType, List<String> knownTranslatorTypes) {
        return MESSAGES.format("unknown-translator-type", new Object[]{translatorType, InternalUtils.join(knownTranslatorTypes)});
    }

    static String validatorSpecificationParseError(int cursor, String specification) {
        return MESSAGES.format("validator-specification-parse-error", new Object[]{Character.valueOf(specification.charAt(cursor)), cursor + 1, specification});
    }

    static String mixinsInvalidWithoutIdOrType(String elementName) {
        return MESSAGES.format("mixins-invalid-without-id-or-type", new Object[]{elementName});
    }

    static String missingFromEnvironment(Class type, Collection<Class> availableTypes) {
        List types = CollectionFactory.newList();
        for (Class c : availableTypes) {
            types.add(c.getName());
        }
        return MESSAGES.format("missing-from-environment", new Object[]{type.getName(), InternalUtils.joinSorted((Collection)types)});
    }

    static String invalidComponentEventResult(Component component, Object result, String methodDescription, Collection<Class> configuredResultTypes) {
        List classNames = CollectionFactory.newList();
        for (Class c : configuredResultTypes) {
            classNames.add(c.getName());
        }
        return MESSAGES.format("invalid-component-event-result", new Object[]{component.getComponentResources().getCompleteId(), result, methodDescription, ClassFabUtils.getJavaClassName(result.getClass()), InternalUtils.joinSorted((Collection)classNames)});
    }

    static String undefinedTapestryElement(String elementName) {
        return MESSAGES.format("undefined-tapestry-element", new Object[]{elementName});
    }

    static String undefinedTapestryAttribute(String elementName, String attributeName, String allowedAttributeName) {
        return MESSAGES.format("undefined-tapestry-attribute", new Object[]{elementName, attributeName, allowedAttributeName});
    }

    static String parameterElementNameRequired() {
        return MESSAGES.get("parameter-element-name-required");
    }

    static String missingApplicationStatePersistenceStrategy(String name, Collection<String> availableNames) {
        return MESSAGES.format("missing-application-state-persistence-strategy", new Object[]{name, InternalUtils.joinSorted(availableNames)});
    }
}

