/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import org.apache.tapestry.internal.services.SessionHolder;
import org.apache.tapestry.services.ApplicationStateCreator;
import org.apache.tapestry.services.ApplicationStatePersistenceStrategy;
import org.apache.tapestry.services.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionApplicationStatePersistenceStrategy
implements ApplicationStatePersistenceStrategy {
    static final String PREFIX = "aso:";
    private final SessionHolder _sessionHolder;

    public SessionApplicationStatePersistenceStrategy(SessionHolder sessionHolder) {
        this._sessionHolder = sessionHolder;
    }

    private Session getSession() {
        return this._sessionHolder.getSession(true);
    }

    @Override
    public <T> T get(Class<T> asoClass, ApplicationStateCreator<T> creator) {
        String key;
        Session session = this.getSession();
        Object aso = session.getAttribute(key = this.buildKey(asoClass));
        if (aso == null) {
            aso = creator.create();
            session.setAttribute(key, aso);
        }
        return (T)aso;
    }

    private <T> String buildKey(Class<T> asoClass) {
        return PREFIX + asoClass.getName();
    }

    @Override
    public <T> void set(Class<T> asoClass, T aso) {
        String key = this.buildKey(asoClass);
        this.getSession().setAttribute(key, aso);
    }
}

