/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.services;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry.events.UpdateListener;
import org.apache.tapestry.internal.services.MessagesBundle;
import org.apache.tapestry.internal.services.MessagesSource;
import org.apache.tapestry.internal.services.MessagesSourceImpl;
import org.apache.tapestry.internal.util.URLChangeTracker;
import org.apache.tapestry.ioc.MessageFormatter;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.services.ValidationMessagesSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationMessagesSourceImpl
implements ValidationMessagesSource,
UpdateListener {
    private final MessagesSource _messagesSource;
    private final MessagesBundle _bundle;
    private final Map<Locale, Messages> _cache = CollectionFactory.newThreadSafeMap();

    public ValidationMessagesSourceImpl(Collection<String> bundles, Resource classpathRoot) {
        this(bundles, classpathRoot, new URLChangeTracker());
    }

    ValidationMessagesSourceImpl(Collection<String> bundles, Resource classpathRoot, URLChangeTracker tracker) {
        this._messagesSource = new MessagesSourceImpl(tracker);
        ValidationMessagesBundle parent = null;
        for (String bundle : bundles) {
            Resource bundleResource = classpathRoot.forFile(bundle);
            parent = new ValidationMessagesBundle(bundleResource, parent);
        }
        this._bundle = parent;
    }

    @Override
    public Messages getValidationMessages(Locale locale) {
        Messages result = this._cache.get(locale);
        if (result == null) {
            result = new ValidationMessages(locale);
            this._cache.put(locale, result);
        }
        return result;
    }

    @Override
    public void checkForUpdates() {
        this._messagesSource.checkForUpdates();
    }

    private class ValidationMessages
    implements Messages {
        private final Locale _locale;

        public ValidationMessages(Locale locale) {
            this._locale = locale;
        }

        private Messages messages() {
            return ValidationMessagesSourceImpl.this._messagesSource.getMessages(ValidationMessagesSourceImpl.this._bundle, this._locale);
        }

        public boolean contains(String key) {
            return this.messages().contains(key);
        }

        public String format(String key, Object ... args) {
            return this.messages().format(key, args);
        }

        public String get(String key) {
            return this.messages().get(key);
        }

        public MessageFormatter getFormatter(String key) {
            return this.messages().getFormatter(key);
        }
    }

    private class ValidationMessagesBundle
    implements MessagesBundle {
        private final Resource _baseResource;
        private final MessagesBundle _parent;

        public ValidationMessagesBundle(Resource baseResource, MessagesBundle parent) {
            this._baseResource = baseResource;
            this._parent = parent;
        }

        public Resource getBaseResource() {
            return this._baseResource;
        }

        public Object getId() {
            return this._baseResource.getPath();
        }

        public MessagesBundle getParent() {
            return this._parent;
        }
    }
}

