/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.structure;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.Binding;
import org.apache.tapestry.Block;
import org.apache.tapestry.BlockNotFoundException;
import org.apache.tapestry.ComponentEventHandler;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Link;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.dom.Element;
import org.apache.tapestry.internal.InternalComponentResources;
import org.apache.tapestry.internal.InternalComponentResourcesCommon;
import org.apache.tapestry.internal.services.ComponentEventImpl;
import org.apache.tapestry.internal.services.EventImpl;
import org.apache.tapestry.internal.services.Instantiator;
import org.apache.tapestry.internal.structure.ComponentCallback;
import org.apache.tapestry.internal.structure.ComponentPageElement;
import org.apache.tapestry.internal.structure.InternalComponentResourcesImpl;
import org.apache.tapestry.internal.structure.Page;
import org.apache.tapestry.internal.structure.PageElement;
import org.apache.tapestry.internal.structure.StructureMessages;
import org.apache.tapestry.internal.util.NotificationEventHandler;
import org.apache.tapestry.ioc.BaseLocatable;
import org.apache.tapestry.ioc.IOCUtilities;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.TapestryException;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.model.ParameterModel;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.runtime.ComponentEvent;
import org.apache.tapestry.runtime.PageLifecycleListener;
import org.apache.tapestry.runtime.RenderCommand;
import org.apache.tapestry.runtime.RenderQueue;
import org.apache.tapestry.services.ComponentMessagesSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPageElementImpl
extends BaseLocatable
implements ComponentPageElement,
PageLifecycleListener {
    private static final ComponentCallback CONTAINING_PAGE_DID_ATTACH = new ComponentCallback(){

        public void run(Component component) {
            component.containingPageDidAttach();
        }
    };
    private static final ComponentCallback CONTAINING_PAGE_DID_DETACH = new ComponentCallback(){

        public void run(Component component) {
            component.containingPageDidDetach();
        }
    };
    private static final ComponentCallback CONTAINING_PAGE_DID_LOAD = new ComponentCallback(){

        public void run(Component component) {
            component.containingPageDidLoad();
        }
    };
    private static final ComponentCallback POST_RENDER_CLEANUP = new ComponentCallback(){

        public void run(Component component) {
            component.postRenderCleanup();
        }
    };
    private final RenderCommand _afterRender = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(false);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.afterRender(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(true, callback);
            if (handler.getResult()) {
                queue.push(ComponentPageElementImpl.this._beginRender);
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("AfterRender");
        }
    };
    private final RenderCommand _afterRenderBody = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(false);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.afterRenderBody(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(true, callback);
            if (handler.getResult()) {
                queue.push(ComponentPageElementImpl.this._beforeRenderBody);
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("AfterRenderBody");
        }
    };
    private final RenderCommand _afterRenderTemplate = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(false);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.afterRenderTemplate(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(true, callback);
            if (handler.getResult()) {
                queue.push(ComponentPageElementImpl.this._beforeRenderTemplate);
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("AfterRenderTemplate");
        }
    };
    private final RenderCommand _beforeRenderBody = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(true);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.beforeRenderBody(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(false, callback);
            queue.push(ComponentPageElementImpl.this._afterRenderBody);
            if (handler.getResult()) {
                ComponentPageElementImpl.pushElements(queue, ComponentPageElementImpl.this._body);
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("BeforeRenderBody");
        }
    };
    private final RenderCommand _beforeRenderTemplate = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(true);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.beforeRenderTemplate(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(false, callback);
            queue.push(ComponentPageElementImpl.this._afterRenderTemplate);
            if (handler.getResult()) {
                ComponentPageElementImpl.pushElements(queue, ComponentPageElementImpl.this._template);
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("BeforeRenderTemplate");
        }
    };
    private final RenderCommand _beginRender = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(true);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.beginRender(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(false, callback);
            if (handler.getResult()) {
                queue.push(ComponentPageElementImpl.this._afterRender);
                queue.push(ComponentPageElementImpl.this._beforeRenderTemplate);
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("BeginRender");
        }
    };
    private Map<String, Block> _blocks;
    private List<PageElement> _body;
    private Map<String, ComponentPageElement> _children;
    private final String _elementName;
    private final RenderCommand _cleanupRender = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(false);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.cleanupRender(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(true, callback);
            if (handler.getResult()) {
                queue.push(ComponentPageElementImpl.this._setupRender);
            } else {
                ComponentPageElementImpl.this._rendering = false;
                Element current = writer.getElement();
                if (current != ComponentPageElementImpl.this._elementAtSetup) {
                    throw new TapestryException(StructureMessages.unbalancedElements(ComponentPageElementImpl.this._completeId), ComponentPageElementImpl.this.getLocation(), null);
                }
                ComponentPageElementImpl.this._elementAtSetup = null;
                ComponentPageElementImpl.this.invoke(false, POST_RENDER_CLEANUP);
                ComponentPageElementImpl.this._page.decrementDirtyCount();
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("CleanupRender");
        }
    };
    private final String _completeId;
    private final Component _coreComponent;
    private final ComponentMessagesSource _messagesSource;
    private List<Component> _components = null;
    private final ComponentPageElement _container;
    private final InternalComponentResources _coreResources;
    private final String _id;
    private boolean _loaded;
    private Map<String, InternalComponentResources> _mixinsByShortName;
    private final String _nestedId;
    private final Page _page;
    private boolean _rendering;
    private Element _elementAtSetup;
    private final RenderCommand _setupRender = new RenderCommand(){

        public void render(final MarkupWriter writer, RenderQueue queue) {
            ComponentPageElementImpl.this._rendering = true;
            ComponentPageElementImpl.this._elementAtSetup = writer.getElement();
            RenderPhaseEventHandler handler = new RenderPhaseEventHandler(true);
            final EventImpl event = new EventImpl(handler);
            ComponentCallback callback = new ComponentCallback(){

                public void run(Component component) {
                    component.setupRender(writer, event);
                }
            };
            ComponentPageElementImpl.this.invoke(false, callback);
            queue.push(ComponentPageElementImpl.this._cleanupRender);
            if (handler.getResult()) {
                queue.push(ComponentPageElementImpl.this._beginRender);
            }
            handler.queueCommands(queue);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("SetupRender");
        }
    };
    private final List<PageElement> _template = CollectionFactory.newList();
    private final TypeCoercer _typeCoercer;

    private static void pushElements(RenderQueue queue, List<PageElement> list) {
        int count = ComponentPageElementImpl.size(list);
        for (int i = count - 1; i >= 0; --i) {
            queue.push(list.get(i));
        }
    }

    private static int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    public ComponentPageElementImpl(Page page, ComponentPageElement container, String id, String elementName, Instantiator instantiator, TypeCoercer typeCoercer, ComponentMessagesSource messagesSource, Location location) {
        super(location);
        this._page = page;
        this._container = container;
        this._id = id;
        this._elementName = elementName;
        this._typeCoercer = typeCoercer;
        this._messagesSource = messagesSource;
        InternalComponentResources containerResources = container == null ? null : container.getComponentResources();
        this._coreResources = new InternalComponentResourcesImpl(this, containerResources, instantiator, this._typeCoercer, this._messagesSource);
        this._coreComponent = this._coreResources.getComponent();
        String pageName = this._page.getName();
        if (container == null) {
            this._completeId = pageName;
            this._nestedId = null;
        } else {
            String caselessId = id.toLowerCase();
            String parentNestedId = container.getNestedId();
            if (parentNestedId == null) {
                this._nestedId = caselessId;
                this._completeId = this._page.getName() + ":" + caselessId;
            } else {
                this._nestedId = parentNestedId + "." + caselessId;
                this._completeId = container.getCompleteId() + "." + caselessId;
            }
        }
    }

    public ComponentPageElementImpl(Page page, Instantiator instantiator, TypeCoercer typeCoercer, ComponentMessagesSource messagesSource) {
        this(page, null, null, null, instantiator, typeCoercer, messagesSource, null);
    }

    @Override
    public void addEmbeddedElement(ComponentPageElement child) {
        String childId;
        ComponentPageElement existing;
        if (this._children == null) {
            this._children = CollectionFactory.newMap();
        }
        if ((existing = this._children.get(childId = child.getId().toLowerCase())) != null) {
            throw new TapestryException(StructureMessages.duplicateChildComponent(this, childId), (Object)child, null);
        }
        this._children.put(childId, child);
    }

    @Override
    public void addMixin(Instantiator instantiator) {
        if (this._mixinsByShortName == null) {
            this._mixinsByShortName = CollectionFactory.newMap();
            this._components = CollectionFactory.newList();
        }
        String mixinClassName = instantiator.getModel().getComponentClassName();
        String mixinName = IOCUtilities.toSimpleId((String)mixinClassName);
        InternalComponentResourcesImpl resources = new InternalComponentResourcesImpl(this, this._coreResources, instantiator, this._typeCoercer, this._messagesSource);
        this._mixinsByShortName.put(mixinName, resources);
        this._components.add(resources.getComponent());
    }

    @Override
    public void bindParameter(String parameterName, Binding binding) {
        int dotx = parameterName.lastIndexOf(46);
        if (dotx > 0) {
            String mixinName = parameterName.substring(0, dotx);
            InternalComponentResources mixinResources = (InternalComponentResources)InternalUtils.get(this._mixinsByShortName, (Object)mixinName);
            if (mixinResources == null) {
                throw new TapestryException(StructureMessages.missingMixinForParameter(this._completeId, mixinName, parameterName), (Object)binding, null);
            }
            String simpleName = parameterName.substring(dotx + 1);
            mixinResources.bindParameter(simpleName, binding);
            return;
        }
        InternalComponentResourcesCommon informalParameterResources = null;
        if (this._coreResources.getComponentModel().getParameterModel(parameterName) != null) {
            this._coreResources.bindParameter(parameterName, binding);
            return;
        }
        for (String mixinName : InternalUtils.sortedKeys(this._mixinsByShortName)) {
            InternalComponentResources resources = this._mixinsByShortName.get(mixinName);
            if (resources.getComponentModel().getParameterModel(parameterName) != null) {
                resources.bindParameter(parameterName, binding);
                return;
            }
            if (informalParameterResources != null || !resources.getComponentModel().getSupportsInformalParameters()) continue;
            informalParameterResources = resources;
        }
        if (informalParameterResources == null && this._coreResources.getComponentModel().getSupportsInformalParameters()) {
            informalParameterResources = this._coreResources;
        }
        if (informalParameterResources != null) {
            informalParameterResources.bindParameter(parameterName, binding);
        }
    }

    @Override
    public void addToBody(PageElement element) {
        if (this._body == null) {
            this._body = CollectionFactory.newList();
        }
        this._body.add(element);
    }

    @Override
    public void addToTemplate(PageElement element) {
        this._template.add(element);
    }

    private void addUnboundParameterNames(String prefix, List<String> unbound, InternalComponentResources resource) {
        ComponentModel model = resource.getComponentModel();
        for (String name : model.getParameterNames()) {
            ParameterModel parameterModel;
            if (resource.isBound(name) || !(parameterModel = model.getParameterModel(name)).isRequired()) continue;
            String fullName = prefix == null ? name : prefix + "." + name;
            unbound.add(fullName);
        }
    }

    @Override
    public void containingPageDidAttach() {
        this.invoke(false, CONTAINING_PAGE_DID_ATTACH);
    }

    @Override
    public void containingPageDidDetach() {
        this.invoke(false, CONTAINING_PAGE_DID_DETACH);
    }

    @Override
    public void containingPageDidLoad() {
        if (this._components != null) {
            List ordered = CollectionFactory.newList();
            Iterator<Component> i = this._components.iterator();
            while (i.hasNext()) {
                Component mixin = i.next();
                if (mixin.getComponentResources().getComponentModel().isMixinAfter()) continue;
                ordered.add(mixin);
                i.remove();
            }
            ordered.add(this._coreComponent);
            ordered.addAll(this._components);
            this._components = ordered;
        }
        this._loaded = true;
        this.invoke(false, CONTAINING_PAGE_DID_LOAD);
        this.verifyRequiredParametersAreBound();
    }

    @Override
    public Link createActionLink(String action, boolean forForm, Object ... context) {
        return this._page.createActionLink(this, action, forForm, context);
    }

    @Override
    public Link createPageLink(String pageName) {
        return this._page.createPageLink(pageName);
    }

    @Override
    public void enqueueBeforeRenderBody(RenderQueue queue) {
        if (this._body != null) {
            queue.push(this._beforeRenderBody);
        }
    }

    @Override
    public String getCompleteId() {
        return this._completeId;
    }

    @Override
    public Component getComponent() {
        return this._coreComponent;
    }

    @Override
    public InternalComponentResources getComponentResources() {
        return this._coreResources;
    }

    @Override
    public ComponentPageElement getContainerElement() {
        return this._container;
    }

    @Override
    public Page getContainingPage() {
        return this._page;
    }

    public Component getEmbeddedComponent(String embeddedId) {
        return this.getEmbeddedElement(embeddedId).getComponent();
    }

    @Override
    public ComponentPageElement getEmbeddedElement(String embeddedId) {
        ComponentPageElement embeddedElement = (ComponentPageElement)InternalUtils.get(this._children, (Object)embeddedId.toLowerCase());
        if (embeddedElement == null) {
            throw new TapestryException(StructureMessages.noSuchComponent(this, embeddedId), (Object)this, null);
        }
        return embeddedElement;
    }

    @Override
    public Object getFieldChange(String fieldName) {
        return this._page.getFieldChange(this, fieldName);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public Log getLog() {
        return this._coreResources.getLog();
    }

    @Override
    public Component getMixinByClassName(String mixinClassName) {
        Component result = null;
        if (this._mixinsByShortName != null) {
            for (InternalComponentResources resources : this._mixinsByShortName.values()) {
                if (!resources.getComponentModel().getComponentClassName().equals(mixinClassName)) continue;
                result = resources.getComponent();
                break;
            }
        }
        if (result == null) {
            throw new TapestryException(StructureMessages.unknownMixin(this._completeId, mixinClassName), this.getLocation(), null);
        }
        return result;
    }

    @Override
    public String getNestedId() {
        return this._nestedId;
    }

    public Component getPage() {
        return this._page.getRootComponent();
    }

    @Override
    public boolean handleEvent(ComponentEvent event) {
        if (this._components == null) {
            return this._coreComponent.handleComponentEvent(event);
        }
        boolean result = false;
        for (Component component : this._components) {
            result |= component.handleComponentEvent(event);
            if (!event.isAborted()) continue;
            break;
        }
        return result;
    }

    @Override
    public boolean hasFieldChange(String fieldName) {
        return this.getFieldChange(fieldName) != null;
    }

    private void invoke(boolean reverse, ComponentCallback callback) {
        Iterator<Component> i;
        if (this._components == null) {
            callback.run(this._coreComponent);
            return;
        }
        Iterator<Component> iterator = i = reverse ? InternalUtils.reverseIterator(this._components) : this._components.iterator();
        while (i.hasNext()) {
            callback.run(i.next());
        }
    }

    @Override
    public boolean isLoaded() {
        return this._loaded;
    }

    @Override
    public boolean isRendering() {
        return this._rendering;
    }

    @Override
    public void persistFieldChange(ComponentResources resources, String fieldName, Object newValue) {
        if (this._loaded) {
            this._page.persistFieldChange(resources, fieldName, newValue);
        }
    }

    private String phaseToString(String phaseName) {
        return String.format("%s[%s]", phaseName, this._completeId);
    }

    @Override
    public final void render(MarkupWriter writer, RenderQueue queue) {
        this._page.incrementDirtyCount();
        queue.push(this._setupRender);
    }

    public String toString() {
        return String.format("ComponentPageElement[%s]", this._completeId);
    }

    @Override
    public boolean triggerEvent(String eventType, Object[] context, ComponentEventHandler handler) {
        boolean result = false;
        if (handler == null) {
            handler = new NotificationEventHandler(eventType, this._completeId);
        }
        ComponentEventImpl event = new ComponentEventImpl(eventType, this._id, context, handler, this._typeCoercer);
        for (ComponentPageElement component = this; component != null; component = component.getContainerElement()) {
            result |= component.handleEvent(event);
            if (!event.isAborted()) continue;
            return result;
        }
        return result;
    }

    private void verifyRequiredParametersAreBound() {
        List unbound = CollectionFactory.newList();
        this.addUnboundParameterNames(null, unbound, this._coreResources);
        for (String name : InternalUtils.sortedKeys(this._mixinsByShortName)) {
            this.addUnboundParameterNames(name, unbound, this._mixinsByShortName.get(name));
        }
        if (unbound.isEmpty()) {
            return;
        }
        throw new TapestryException(StructureMessages.missingParameters(unbound, this), (Object)this, null);
    }

    @Override
    public Locale getLocale() {
        return this._page.getLocale();
    }

    @Override
    public String getElementName() {
        return this._elementName;
    }

    @Override
    public void queueRender(RenderQueue queue) {
        queue.push(this);
    }

    @Override
    public Block getBlock(String id) {
        Defense.notBlank((String)id, (String)"id");
        Block result = (Block)InternalUtils.get(this._blocks, (Object)id.toLowerCase());
        if (result == null) {
            throw new BlockNotFoundException(StructureMessages.blockNotFound(this._completeId, id), this.getLocation());
        }
        return result;
    }

    @Override
    public void addBlock(String blockId, Block block) {
        String caselessId;
        if (this._blocks == null) {
            this._blocks = CollectionFactory.newMap();
        }
        if (this._blocks.containsKey(caselessId = blockId.toLowerCase())) {
            throw new TapestryException(StructureMessages.duplicateBlock(this, blockId), (Object)block, null);
        }
        this._blocks.put(caselessId, block);
    }

    @Override
    public String getDefaultBindingPrefix(String parameterName) {
        int dotx = parameterName.lastIndexOf(46);
        if (dotx > 0) {
            String mixinName = parameterName.substring(0, dotx);
            InternalComponentResources mixinResources = (InternalComponentResources)InternalUtils.get(this._mixinsByShortName, (Object)mixinName);
            if (mixinResources == null) {
                throw new TapestryException(StructureMessages.missingMixinForParameter(this._completeId, mixinName, parameterName), null, null);
            }
            String simpleName = parameterName.substring(dotx + 1);
            ParameterModel pm = mixinResources.getComponentModel().getParameterModel(simpleName);
            return pm != null ? pm.getDefaultBindingPrefix() : null;
        }
        ParameterModel pm = this._coreResources.getComponentModel().getParameterModel(parameterName);
        if (pm != null) {
            return pm.getDefaultBindingPrefix();
        }
        for (String mixinName : InternalUtils.sortedKeys(this._mixinsByShortName)) {
            InternalComponentResources resources = this._mixinsByShortName.get(mixinName);
            pm = resources.getComponentModel().getParameterModel(parameterName);
            if (pm == null) continue;
            return pm.getDefaultBindingPrefix();
        }
        return null;
    }

    private static class RenderPhaseEventHandler
    implements ComponentEventHandler {
        private boolean _result;
        private List<RenderCommand> _commands;

        public RenderPhaseEventHandler(boolean defaultResult) {
            this._result = defaultResult;
        }

        boolean getResult() {
            return this._result;
        }

        public boolean handleResult(Object result, Component component, String methodDescription) {
            if (result instanceof Boolean) {
                this._result = (Boolean)result;
                return true;
            }
            if (result instanceof RenderCommand) {
                RenderCommand command = (RenderCommand)result;
                this.add(command);
                return false;
            }
            throw new TapestryException(StructureMessages.wrongEventResultType(methodDescription, Boolean.class), (Object)component, null);
        }

        private void add(RenderCommand command) {
            if (this._commands == null) {
                this._commands = CollectionFactory.newList();
            }
            this._commands.add(command);
        }

        public void queueCommands(RenderQueue queue) {
            if (this._commands == null) {
                return;
            }
            for (RenderCommand command : this._commands) {
                queue.push(command);
            }
        }
    }
}

