/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.structure;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tapestry.AnnotationProvider;
import org.apache.tapestry.Binding;
import org.apache.tapestry.Block;
import org.apache.tapestry.ComponentEventHandler;
import org.apache.tapestry.ComponentResources;
import org.apache.tapestry.Link;
import org.apache.tapestry.MarkupWriter;
import org.apache.tapestry.internal.InternalComponentResources;
import org.apache.tapestry.internal.services.Instantiator;
import org.apache.tapestry.internal.structure.ComponentPageElement;
import org.apache.tapestry.internal.structure.StructureMessages;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.internal.util.TapestryException;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.model.ComponentModel;
import org.apache.tapestry.runtime.Component;
import org.apache.tapestry.runtime.RenderQueue;
import org.apache.tapestry.services.ComponentMessagesSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalComponentResourcesImpl
implements InternalComponentResources {
    private final ComponentModel _componentModel;
    private final ComponentPageElement _element;
    private final TypeCoercer _typeCoercer;
    private final Component _component;
    private final ComponentResources _containerResources;
    private Map<String, Binding> _bindings;
    private final ComponentMessagesSource _messagesSource;
    private Messages _messages;

    public InternalComponentResourcesImpl(ComponentPageElement element, ComponentResources containerResources, Instantiator componentInstantiator, TypeCoercer typeCoercer, ComponentMessagesSource messagesSource) {
        this._element = element;
        this._containerResources = containerResources;
        this._componentModel = componentInstantiator.getModel();
        this._typeCoercer = typeCoercer;
        this._messagesSource = messagesSource;
        this._component = componentInstantiator.newInstance(this);
    }

    public String toString() {
        return String.format("InternalComponentResources[%s]", this.getCompleteId());
    }

    @Override
    public ComponentModel getComponentModel() {
        return this._componentModel;
    }

    @Override
    public Component getEmbeddedComponent(String embeddedId) {
        return this._element.getEmbeddedElement(embeddedId).getComponent();
    }

    @Override
    public Object getFieldChange(String fieldName) {
        return this._element.getFieldChange(fieldName);
    }

    @Override
    public String getId() {
        return this._element.getId();
    }

    @Override
    public boolean hasFieldChange(String fieldName) {
        return this._element.hasFieldChange(fieldName);
    }

    @Override
    public Link createActionLink(String action, boolean forForm, Object ... context) {
        return this._element.createActionLink(action, forForm, context);
    }

    @Override
    public Link createPageLink(String pageName) {
        return this._element.createPageLink(pageName);
    }

    @Override
    public String getCompleteId() {
        return this._element.getCompleteId();
    }

    @Override
    public Component getComponent() {
        return this._component;
    }

    @Override
    public boolean isBound(String parameterName) {
        return this.getBinding(parameterName) != null;
    }

    @Override
    public boolean isRendering() {
        return this._element.isRendering();
    }

    @Override
    public boolean triggerEvent(String eventType, Object[] context, ComponentEventHandler handler) {
        return this._element.triggerEvent(eventType, context, handler);
    }

    @Override
    public String getNestedId() {
        return this._element.getNestedId();
    }

    @Override
    public Component getPage() {
        return this._element.getContainingPage().getRootComponent();
    }

    @Override
    public boolean isInvariant(String parameterName) {
        Binding b = this.getBinding(parameterName);
        return b != null && b.isInvariant();
    }

    @Override
    public boolean isLoaded() {
        return this._element.isLoaded();
    }

    @Override
    public void persistFieldChange(String fieldName, Object newValue) {
        this._element.persistFieldChange(this, fieldName, newValue);
    }

    @Override
    public void bindParameter(String parameterName, Binding binding) {
        if (this._bindings == null) {
            this._bindings = CollectionFactory.newMap();
        }
        this._bindings.put(parameterName.toLowerCase(), binding);
    }

    @Override
    public <T> T readParameter(String parameterName, Class<T> expectedType) {
        Binding b = this.getBinding(parameterName);
        try {
            Object boundValue = b.get();
            return (T)this._typeCoercer.coerce(boundValue, expectedType);
        }
        catch (Exception ex) {
            throw new TapestryException(StructureMessages.getParameterFailure(parameterName, this.getCompleteId(), ex), (Throwable)ex);
        }
    }

    @Override
    public Class getBoundType(String parameterName) {
        Binding b = this.getBinding(parameterName);
        return b != null ? b.getBindingType() : null;
    }

    @Override
    public <T> void writeParameter(String parameterName, T parameterValue) {
        Binding b = this.getBinding(parameterName);
        Class bindingType = b.getBindingType();
        try {
            Object coerced = this._typeCoercer.coerce(parameterValue, bindingType);
            b.set(coerced);
        }
        catch (Exception ex) {
            throw new TapestryException(StructureMessages.writeParameterFailure(parameterName, this.getCompleteId(), ex), InternalUtils.locationOf((Object)b), (Throwable)ex);
        }
    }

    private Binding getBinding(String parameterName) {
        return this._bindings == null ? null : this._bindings.get(parameterName.toLowerCase());
    }

    @Override
    public AnnotationProvider getAnnotationProvider(String parameterName) {
        return this.getBinding(parameterName);
    }

    @Override
    public Log getLog() {
        return this._componentModel.getLog();
    }

    @Override
    public Component getMixinByClassName(String mixinClassName) {
        return this._element.getMixinByClassName(mixinClassName);
    }

    @Override
    public void renderInformalParameters(MarkupWriter writer) {
        if (this._bindings == null) {
            return;
        }
        for (String name : this._bindings.keySet()) {
            if (this._componentModel.getParameterModel(name) != null) continue;
            writer.attributes(name, this.readParameter(name, String.class));
        }
    }

    @Override
    public Component getContainer() {
        ComponentPageElement containerElement = this._element.getContainerElement();
        return containerElement == null ? null : containerElement.getComponent();
    }

    @Override
    public ComponentResources getContainerResources() {
        return this._containerResources;
    }

    @Override
    public Messages getContainerMessages() {
        return this._containerResources != null ? this._containerResources.getMessages() : null;
    }

    @Override
    public Locale getLocale() {
        return this._element.getLocale();
    }

    @Override
    public Messages getMessages() {
        if (this._messages == null) {
            this._messages = this._messagesSource.getMessages(this._componentModel, this.getLocale());
        }
        return this._messages;
    }

    @Override
    public Component getCoreComponent() {
        return this._element.getComponent();
    }

    @Override
    public String getElementName() {
        return this._element.getElementName();
    }

    @Override
    public void queueRender(RenderQueue queue) {
        this._element.queueRender(queue);
    }

    @Override
    public Block getBlock(String blockId) {
        return this._element.getBlock(blockId);
    }
}

