/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerRange
implements Iterable<Integer> {
    private final int _start;
    private final int _finish;

    public IntegerRange(int start, int finish) {
        this._start = start;
        this._finish = finish;
    }

    public int getFinish() {
        return this._finish;
    }

    public int getStart() {
        return this._start;
    }

    public String toString() {
        return String.format("%d..%d", this._start, this._finish);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new RangeIterator();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 31 + this._finish;
        result = 31 * result + this._start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerRange other = (IntegerRange)obj;
        if (this._finish != other._finish) {
            return false;
        }
        return this._start == other._start;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RangeIterator
    implements Iterator<Integer> {
        private final int _increment;
        private int _value;
        private boolean _hasNext;

        RangeIterator() {
            this._value = IntegerRange.this._start;
            this._hasNext = true;
            this._increment = IntegerRange.this._start < IntegerRange.this._finish ? 1 : -1;
        }

        @Override
        public boolean hasNext() {
            return this._hasNext;
        }

        @Override
        public Integer next() {
            if (!this._hasNext) {
                throw new IllegalStateException();
            }
            int result = this._value;
            this._hasNext = this._value != IntegerRange.this._finish;
            this._value += this._increment;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

