/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.internal.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.tapestry.internal.util.UtilMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;

public class URLChangeTracker {
    private final Map<URL, Long> _urlToTimestamp = CollectionFactory.newThreadSafeMap();

    public long add(URL url) {
        if (this._urlToTimestamp.containsKey(url)) {
            return this._urlToTimestamp.get(url);
        }
        long timestamp = this.readTimestamp(url);
        this._urlToTimestamp.put(url, timestamp);
        return timestamp;
    }

    public void clear() {
        this._urlToTimestamp.clear();
    }

    public boolean containsChanges() {
        boolean result = false;
        for (Map.Entry<URL, Long> entry : this._urlToTimestamp.entrySet()) {
            long newTimestamp = this.readTimestamp(entry.getKey());
            long current = entry.getValue();
            if (current == newTimestamp) continue;
            result = true;
            entry.setValue(newTimestamp);
        }
        return result;
    }

    private long readTimestamp(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.connect();
            long result = connection.getLastModified();
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException(UtilMessages.unableToReadLastModified(url, ex), ex);
        }
    }

    public void forceChange() {
        for (Map.Entry<URL, Long> e : this._urlToTimestamp.entrySet()) {
            e.setValue(0L);
        }
    }
}

