/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services;

import java.util.Locale;
import org.apache.tapestry.services.Cookies;
import org.apache.tapestry.services.PersistentLocale;

public class PersistentLocaleImpl
implements PersistentLocale {
    private static final String LOCALE_COOKIE_NAME = "org.apache.tapestry.locale";
    private Cookies _cookieSource;

    public PersistentLocaleImpl(Cookies cookieSource) {
        this._cookieSource = cookieSource;
    }

    public void set(Locale locale) {
        this._cookieSource.writeCookieValue(LOCALE_COOKIE_NAME, locale.toString());
    }

    public Locale get() {
        String localeCookieValue = this.getCookieValue();
        return localeCookieValue != null ? new Locale(localeCookieValue) : null;
    }

    private String getCookieValue() {
        return this._cookieSource.readCookieValue(LOCALE_COOKIE_NAME);
    }

    public boolean isSet() {
        return this.getCookieValue() != null;
    }
}

