/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services;

import java.util.Map;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;

public final class TransformUtils {
    private static final Map<String, PrimitiveTypeInfo> _nameToInfo = CollectionFactory.newMap();
    private static final Map<Class, PrimitiveTypeInfo> _classToInfo = CollectionFactory.newMap();

    private TransformUtils() {
    }

    private static void add(Class primitiveType, Class wrapperType, String unwrapperMethodName, String defaultValue) {
        PrimitiveTypeInfo info = new PrimitiveTypeInfo(wrapperType, unwrapperMethodName, defaultValue);
        _classToInfo.put(primitiveType, info);
        _nameToInfo.put(primitiveType.getName(), info);
    }

    public static boolean isPrimitive(String type) {
        return _nameToInfo.containsKey(type);
    }

    public static String getWrapperTypeName(String type) {
        PrimitiveTypeInfo info = _nameToInfo.get(type);
        return info == null ? type : info.getWrapperType().getName();
    }

    public static String getUnwrapperMethodName(String type) {
        PrimitiveTypeInfo info = _nameToInfo.get(type);
        return info == null ? null : info.getUnwrapperMethodName();
    }

    public static Class getWrapperType(Class type) {
        PrimitiveTypeInfo info = _classToInfo.get(type);
        return info == null ? type : info.getWrapperType();
    }

    public static String getDefaultValue(String type) {
        PrimitiveTypeInfo info = _nameToInfo.get(type);
        return info == null ? "null" : info.getDefaultValue();
    }

    static {
        TransformUtils.add(Boolean.TYPE, Boolean.class, "booleanValue", "false");
        TransformUtils.add(Byte.TYPE, Byte.class, "byteValue", "0");
        TransformUtils.add(Character.TYPE, Character.class, "charValue", "0");
        TransformUtils.add(Short.TYPE, Short.class, "shortValue", "0");
        TransformUtils.add(Integer.TYPE, Integer.class, "intValue", "0");
        TransformUtils.add(Long.TYPE, Long.class, "longValue", "0L");
        TransformUtils.add(Float.TYPE, Float.class, "floatValue", "0.0f");
        TransformUtils.add(Double.TYPE, Double.class, "doubleValue", "0.0d");
    }

    static class PrimitiveTypeInfo {
        private final Class _wrapperType;
        private final String _unwrapperMethodName;
        private final String _defaultValue;

        public PrimitiveTypeInfo(Class wrapperType, String unwrapperMethodName, String defaultValue) {
            this._wrapperType = wrapperType;
            this._unwrapperMethodName = unwrapperMethodName;
            this._defaultValue = defaultValue;
        }

        public String getUnwrapperMethodName() {
            return this._unwrapperMethodName;
        }

        public String getDefaultValue() {
            return this._defaultValue;
        }

        public Class getWrapperType() {
            return this._wrapperType;
        }
    }
}

