/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.ref.SoftReference;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.ThrowawayClassLoader;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.internal.services.PageLoader;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentMessages;
import org.apache.tapestry5.services.ComponentTemplates;
import org.apache.tapestry5.services.pageload.ComponentRequestSelectorAnalyzer;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.apache.tapestry5.services.pageload.PageCachingReferenceTypeService;
import org.apache.tapestry5.services.pageload.PageClassLoaderContext;
import org.apache.tapestry5.services.pageload.PageClassLoaderContextManager;
import org.apache.tapestry5.services.pageload.ReferenceType;
import org.slf4j.Logger;

public class PageSourceImpl
implements PageSource {
    private final ComponentRequestSelectorAnalyzer selectorAnalyzer;
    private final PageLoader pageLoader;
    private final ComponentDependencyRegistry componentDependencyRegistry;
    private final ComponentClassResolver componentClassResolver;
    private final PageClassLoaderContextManager pageClassLoaderContextManager;
    private final PageCachingReferenceTypeService pageCachingReferenceTypeService;
    private final Logger logger;
    private final boolean productionMode;
    private final boolean multipleClassLoaders;
    private final Map<CachedPageKey, Object> pageCache = CollectionFactory.newConcurrentMap();
    private final Map<String, Boolean> abstractClassInfoCache = CollectionFactory.newConcurrentMap();
    private static final ThreadLocal<Set<String>> CALL_STACK = ThreadLocal.withInitial(HashSet::new);

    public PageSourceImpl(PageLoader pageLoader, ComponentRequestSelectorAnalyzer selectorAnalyzer, ComponentDependencyRegistry componentDependencyRegistry, ComponentClassResolver componentClassResolver, PageClassLoaderContextManager pageClassLoaderContextManager, PageCachingReferenceTypeService pageCachingReferenceTypeService, @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders, Logger logger) {
        this.pageLoader = pageLoader;
        this.selectorAnalyzer = selectorAnalyzer;
        this.componentDependencyRegistry = componentDependencyRegistry;
        this.componentClassResolver = componentClassResolver;
        this.productionMode = productionMode;
        this.pageCachingReferenceTypeService = pageCachingReferenceTypeService;
        this.multipleClassLoaders = multipleClassLoaders && !productionMode;
        this.pageClassLoaderContextManager = pageClassLoaderContextManager;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getPage(String canonicalPageName) {
        if (!this.productionMode) {
            this.componentDependencyRegistry.disableInvalidations();
        }
        try {
            Set alreadyProcessed = this.multipleClassLoaders ? new HashSet() : Collections.EMPTY_SET;
            Page page = this.getPage(canonicalPageName, true, alreadyProcessed);
            return page;
        }
        finally {
            if (!this.productionMode) {
                this.componentDependencyRegistry.enableInvalidations();
            }
        }
    }

    public Page getPage(String canonicalPageName, boolean invalidateUnknownContext, Set<String> alreadyProcessed) {
        PageClassLoaderContext context;
        String className;
        ComponentResourceSelector selector = this.selectorAnalyzer.buildSelectorForRequest();
        CachedPageKey key = new CachedPageKey(canonicalPageName, selector);
        while (true) {
            Object object;
            Page page;
            if ((page = this.toPage(object = this.pageCache.get(key))) != null) {
                return page;
            }
            className = this.componentClassResolver.resolvePageNameToClassName(canonicalPageName);
            if (this.multipleClassLoaders) {
                List<String> pageDependencies = this.getPageDependencies(className);
                CALL_STACK.get().add(className);
                for (String dependencyClassName : pageDependencies) {
                    if (alreadyProcessed.contains(dependencyClassName) || CALL_STACK.get().contains(className)) continue;
                    alreadyProcessed.add(dependencyClassName);
                    String dependencyPageName = this.componentClassResolver.resolvePageClassNameToPageName(dependencyClassName);
                    String resolvedDependencyPageClass = this.componentClassResolver.resolvePageNameToClassName(dependencyPageName);
                    if (canonicalPageName.equals(dependencyPageName) || className.equals(resolvedDependencyPageClass) || this.isAbstract(dependencyClassName)) continue;
                    page = this.getPage(dependencyPageName, invalidateUnknownContext, alreadyProcessed);
                }
            }
            page = this.pageLoader.loadPage(canonicalPageName, selector);
            ReferenceType referenceType = this.pageCachingReferenceTypeService.get(canonicalPageName);
            if (referenceType.equals((Object)ReferenceType.SOFT)) {
                this.pageCache.put(key, new SoftReference<Page>(page));
            } else {
                this.pageCache.put(key, page);
            }
            if (this.productionMode) continue;
            ComponentPageElement rootElement = page.getRootElement();
            this.componentDependencyRegistry.clear(rootElement);
            this.componentDependencyRegistry.register(rootElement.getComponent().getClass());
            context = this.pageClassLoaderContextManager.get(className);
            if (context.isUnknown() && this.multipleClassLoaders) break;
        }
        this.pageCache.remove(key);
        if (invalidateUnknownContext) {
            this.pageClassLoaderContextManager.invalidateAndFireInvalidationEvents(context);
            this.getPageDependencies(className);
        }
        context.getClassNames().clear();
        return this.getPage(canonicalPageName, false, alreadyProcessed);
    }

    private List<String> getPageDependencies(String className) {
        ArrayList<String> pageDependencies = new ArrayList<String>();
        pageDependencies.addAll(new ArrayList<String>(this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.INJECT_PAGE)));
        pageDependencies.addAll(new ArrayList<String>(this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.SUPERCLASS)));
        Iterator iterator = pageDependencies.iterator();
        while (iterator.hasNext()) {
            String dependency = (String)iterator.next();
            if (dependency.contains(".pages.") || dependency.equals(className)) continue;
            iterator.remove();
        }
        return pageDependencies;
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub classesHub, @ComponentTemplates InvalidationEventHub templatesHub, @ComponentMessages InvalidationEventHub messagesHub, ResourceChangeTracker resourceChangeTracker) {
        classesHub.addInvalidationCallback(this::listen);
        templatesHub.addInvalidationCallback(this::listen);
        messagesHub.addInvalidationCallback(this::listen);
        resourceChangeTracker.addInvalidationCallback(this::listen);
    }

    private List<String> listen(List<String> resources) {
        if (resources.isEmpty()) {
            this.clearCache();
        } else {
            for (String className : resources) {
                if (!this.componentClassResolver.isPage(className)) continue;
                String pageName = this.componentClassResolver.resolvePageClassNameToPageName(className);
                Iterator<Map.Entry<CachedPageKey, Object>> iterator = this.pageCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<CachedPageKey, Object> entry = iterator.next();
                    String entryPageName = entry.getKey().pageName;
                    if (!entryPageName.equalsIgnoreCase(pageName)) continue;
                    this.logger.info("Clearing cached page '{}'", (Object)pageName);
                    iterator.remove();
                }
                this.abstractClassInfoCache.remove(className);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void clearCache() {
        this.logger.info("Clearing page cache");
        this.pageCache.clear();
    }

    @Override
    public Set<Page> getAllPages() {
        return ((Flow)F.flow(this.pageCache.values()).map((Mapper)new Mapper<Object, Page>(){

            public Page map(Object object) {
                return PageSourceImpl.this.toPage(object);
            }
        }).removeNulls()).toSet();
    }

    private Page toPage(Object object) {
        SoftReference ref;
        Page page = object instanceof SoftReference ? ((ref = (SoftReference)object) == null ? null : (Page)ref.get()) : (Page)object;
        return page;
    }

    private boolean isAbstract(String className) {
        Boolean computeIfAbsent = this.abstractClassInfoCache.computeIfAbsent(className, s -> Modifier.isAbstract(ThrowawayClassLoader.load(className).getModifiers()));
        return computeIfAbsent;
    }

    private static final class CachedPageKey {
        final String pageName;
        final ComponentResourceSelector selector;

        public CachedPageKey(String pageName, ComponentResourceSelector selector) {
            this.pageName = pageName;
            this.selector = selector;
        }

        public int hashCode() {
            return 37 * this.pageName.hashCode() + this.selector.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CachedPageKey)) {
                return false;
            }
            CachedPageKey other = (CachedPageKey)obj;
            return this.pageName.equals(other.pageName) && this.selector.equals(other.selector);
        }

        public String toString() {
            return "CachedPageKey [pageName=" + this.pageName + ", selector=" + this.selector + "]";
        }
    }
}

